<?php
/**
 * The template for displaying login form.
 *
 * Override this template by copying it to yourtheme/userpress/layoutname/form-login.php
 *
 * @author 		UserPress
 * @package 	UserPress/Templates
 * @version     1.0.0
 */

if (! defined ( 'ABSPATH' )) {
	exit (); // Exit if accessed directly
}
?>
<div class="user-press-body user-press-login">
	<div class="login-form" >
		<div class="fields-content">
			<div class="field-group">
				<label><?php echo esc_html__( 'Username *', 'user-press' ) ?></label>
				<input id="user" type="text" class="input user_name" placeholder="<?php esc_html_e('Username', 'user-press'); ?>" data-validate="<?php esc_html_e('Required Field', 'user-press'); ?>">
			</div>
			<div class="field-group">
				<label><?php echo esc_html__( 'Password *', 'user-press' ) ?></label>
				<input id="pass" type="password" class="input password" placeholder="<?php esc_html_e('Password', 'user-press'); ?>" data-validate="<?php esc_html_e('Required Field', 'user-press'); ?>">
			</div>
			<div class="field-group field-footer-group">
				<button type="button" class="button button-login"><?php esc_html_e('Log In', 'user-press');?></button>
				<div class="user-press-forgot-pass">
					<a href="<?php echo wp_lostpassword_url(get_permalink()); ?>"><i class="fa fa-unlock-alt"></i><?php esc_html_e('Forgot Password?', 'user-press') ?></a>
				</div>
			</div>
		</div>
	</div>
</div>
