<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package UnfinityPlus
 */

$title_404_page = unfinityplus_get_opt('title_404_page');
$desc_404_page = unfinityplus_get_opt('desc_404_page');
$btn_text_404_page = unfinityplus_get_opt('btn_text_404_page');

get_header(); ?>

    <div id="primary" class="content-area">
        <main id="main" class="site-main">
            <div class="row">
                <div class="col-12">
                    <section class="error-404 text-center">
                        <header>
                            <h1>
                                <?php if(!empty($title_404_page)) { echo esc_attr($title_404_page); } else { echo esc_html__( 'Oops! That page can&rsquo;t be found.', 'unfinityplus' ); } ?>
                            </h1>
                        </header><!-- .page-title -->

                        <div class="page-content">
                            <p><?php if(!empty($desc_404_page)) { echo wp_kses_post($desc_404_page); } else { echo esc_html__( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'unfinityplus' ); } ?></p>
                            <a class="btn" href="<?php echo esc_url(home_url('/')); ?>"><?php if(!empty($btn_text_404_page)) { echo esc_attr($btn_text_404_page); } else { echo esc_html__('Return To Homepage', 'unfinityplus'); } ?></a>
                        </div><!-- .page-content -->
                    </section><!-- .error-404 -->
                </div>
            </div>
        </main><!-- #main -->
    </div><!-- #primary -->

<?php
get_footer();
