<?php
if ( ! class_exists( 'ReduxFrameworkInstances' ) )
{
    return;
}

/*
 * Convert HEX to GRBA
 */
if(!function_exists('unfinityplus_rgba')){
    function unfinityplus_rgba($hex,$opacity = 1) {
        $hex = str_replace("#",null, $hex);
        $color = array();
        if(strlen($hex) == 3) {
            $color['r'] = hexdec(substr($hex,0,1).substr($hex,0,1));
            $color['g'] = hexdec(substr($hex,1,1).substr($hex,1,1));
            $color['b'] = hexdec(substr($hex,2,1).substr($hex,2,1));
            $color['a'] = $opacity;
        }
        else if(strlen($hex) == 6) {
            $color['r'] = hexdec(substr($hex, 0, 2));
            $color['g'] = hexdec(substr($hex, 2, 2));
            $color['b'] = hexdec(substr($hex, 4, 2));
            $color['a'] = $opacity;
        }
        $color = "rgba(".implode(', ', $color).")";
        return $color;
    }
}

/*
 * Convert HEX to Dark & Lighten
 */
function unfinityplus_lighten( $hex, $percent ) {
    
    // validate hex string
    
    $hex = preg_replace( '/[^0-9a-f]/i', '', $hex );
    $new_hex = '#';
    
    if ( strlen( $hex ) < 6 ) {
        $hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
    }
    
    // convert to decimal and change luminosity
    for ($i = 0; $i < 3; $i++) {
        $dec = hexdec( substr( $hex, $i*2, 2 ) );
        $dec = min( max( 0, $dec + $dec * $percent ), 255 ); 
        $new_hex .= str_pad( dechex( $dec ) , 2, 0, STR_PAD_LEFT );
    }       
    
    return $new_hex;
}

class CSS_Generator
{
    /**
     * scssc class instance
     *
     * @access protected
     * @var scssc
     */
    protected $scssc = null;

    /**
     * ReduxFramework class instance
     *
     * @access protected
     * @var ReduxFramework
     */
    protected $redux = null;

    /**
     * Debug mode is turn on or not
     *
     * @access protected
     * @var boolean
     */
    protected $dev_mode = true;

    /**
     * opt_name of ReduxFramework
     *
     * @access protected
     * @var string
     */
    protected $opt_name = '';


    /**
     * Constructor
     */
    function __construct() {
        $this->opt_name = unfinityplus_get_opt_name();

        if ( empty( $this->opt_name ) ) {
            return;
        }
        $this->dev_mode = unfinityplus_get_opt( 'dev_mode', '0' ) === '1' ? true : false;
        add_filter( 'cms_scssc_on', '__return_true' );
        add_action( 'init', array( $this, 'init' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue' ), 20 );
    }

    /**
     * init hook - 10
     */
    function init() {
        if ( ! class_exists( 'scssc' ) ) {
            return;
        }

        $this->redux = ReduxFrameworkInstances::get_instance( $this->opt_name );

        if ( empty( $this->redux ) || ! $this->redux instanceof ReduxFramework ) {
            return;
        }
        add_action( 'wp', array( $this, 'generate_with_dev_mode' ) );
        add_action( "redux/options/{$this->opt_name}/saved", function () {
            $this->generate_file();
        } );
    }

    function generate_with_dev_mode() {
        if ( $this->dev_mode === true ) {
            $this->generate_file();
        }
    }

    /**
     * Generate options and css files
     */
    function generate_file() {
        $scss_dir = get_template_directory() . '/assets/scss/';
        $css_dir  = get_template_directory() . '/assets/css/';

        $this->scssc = new scssc();
        $this->scssc->setImportPaths( $scss_dir );

        $_options = $scss_dir . 'variables.scss';

        $this->redux->filesystem->execute( 'put_contents', $_options, array(
            'content' => preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->options_output() )
        ) );
        $css_file = $css_dir . 'theme.css';

        $this->scssc->setFormatter( 'scss_formatter' );
        $this->redux->filesystem->execute( 'put_contents', $css_file, array(
            'content' => preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->scssc->compile( '@import "theme.scss"' ) )
        ) );
    }

    /**
     * Output options to _variables.scss
     *
     * @access protected
     * @return string
     */
    protected function options_output()
    {
        ob_start();

        $primary_color = unfinityplus_get_opt( 'primary_color', '#b09991' );
        if ( ! unfinityplus_is_valid_color( $primary_color ) )
        {
            $primary_color = '#b09991';
        }
        printf( '$primary_color: %s;', esc_attr( $primary_color ) );

        $secondary_color = unfinityplus_get_opt( 'secondary_color', '#000000' );
        if ( ! unfinityplus_is_valid_color( $secondary_color ) )
        {
            $secondary_color = '#000000';
        }
        printf( '$secondary_color: %s;', esc_attr( $secondary_color ) );

        $link_color = unfinityplus_get_opt( 'link_color', '#b09991' );
        if ( !empty($link_color['regular']) && isset($link_color['regular']) )
        {
            printf( '$link_color: %s;', esc_attr( $link_color['regular'] ) );
        } else {
            echo '$link_color: #b09991;';
        }

        $link_color_hover = unfinityplus_get_opt( 'link_color', '#e09c0b' );
        if ( !empty($link_color['hover']) && isset($link_color['hover']) )
        {
            printf( '$link_color_hover: %s;', esc_attr( $link_color['hover'] ) );
        } else {
            echo '$link_color_hover: #f3bc0b;';
        }

        $link_color_active = unfinityplus_get_opt( 'link_color', '#e09c0b' );
        if ( !empty($link_color['active']) && isset($link_color['active']) )
        {
            printf( '$link_color_active: %s;', esc_attr( $link_color['active'] ) );
        } else {
            echo '$link_color_active: #f3bc0b;';
        }

        $primary_color_gradient = unfinityplus_get_opt( 'primary_color_gradient' );
        if ( !empty($primary_color_gradient['from']) && isset($primary_color_gradient['from']) )
        {
            printf( '$primary_color_from: %s;', esc_attr( $primary_color_gradient['from'] ) );
        } else {
            echo '$primary_color_from: '.$primary_color.';';
        }
        if ( !empty($primary_color_gradient['to']) && isset($primary_color_gradient['to']) )
        {
            printf( '$primary_color_to: %s;', esc_attr( $primary_color_gradient['to'] ) );
        } else {
            echo '$primary_color_to: '.$primary_color.';';
        }

        return ob_get_clean();
    }

    /**
     * Hooked wp_enqueue_scripts - 20
     * Make sure that the handle is enqueued from earlier wp_enqueue_scripts hook.
     */
    function enqueue()
    {
        $css = $this->inline_css();
        $this->dev_mode = true;
        if ( !empty($css) )
        {
            wp_add_inline_style( 'unfinityplus-theme', $this->dev_mode ? $css : unfinityplus_css_minifier( $css ) );
        }
    }

    /**
     * Generate inline css based on theme options
     */
    protected function inline_css()
    {
        ob_start();
        /* Header */
        $h_bg_color = unfinityplus_get_opt( 'h_bg_color' );
        $h_bg_top_color = unfinityplus_get_opt( 'h_bg_top_color' );
        $h_text_top_color = unfinityplus_get_opt( 'h_text_top_color' );
        if(!empty($h_bg_top_color)) {
            echo '#site-header-wrap #site-topbar {
                background-color: '.esc_attr( $h_bg_top_color ).' !important;
            }';
        }
        if(!empty($h_text_top_color)) {
            echo '#site-header-wrap #site-topbar, #site-header-wrap #site-topbar .site-topbar-contact li {
                color: '.esc_attr( $h_text_top_color ).' !important;
            }';
        }
        if(!empty($h_bg_color)) {
            echo '#site-header-wrap #site-header.site-header-main {
                background-color: '.esc_attr( $h_bg_color ).';
            }';
        }

        $h_bg_color_mobile = unfinityplus_get_opt( 'h_bg_color_mobile' );
        $nav_icon_mobile = unfinityplus_get_opt( 'nav_icon_mobile' ); ?>
        @media screen and (max-width: 991px) {
            <?php if(!empty($h_bg_color_mobile)) {
                echo 'body #site-header-wrap #site-header.site-header-main {
                    background-color: '.esc_attr( $h_bg_color_mobile ).';
                }';
            } ?>
            <?php if(!empty($nav_icon_mobile)) {
                echo 'body #main-menu-mobile .btn-nav-mobile:before, body #main-menu-mobile .btn-nav-mobile:after, body #main-menu-mobile .btn-nav-mobile span {
                    background-color: '.esc_attr( $nav_icon_mobile ).';
                }';
            } ?>
        }

        <?php /* Logo */
        $logo_maxh = unfinityplus_get_opt( 'logo_maxh' );

        if (!empty($logo_maxh['height']) && $logo_maxh['height'] != 'px')
        {
            printf( '#site-header-wrap .site-branding a img { max-height: %s; }', esc_attr($logo_maxh['height']) );
        }

        /* Menu */ ?>
        @media screen and (min-width: 992px) {
            <?php 
                $menu_font_weight = unfinityplus_get_opt( 'menu_font_weight' );
                if ( !empty( $menu_font_weight ) ) {
                    printf( '.primary-menu > li > a { font-weight: %s !important; }', esc_attr($menu_font_weight) );
                }
                $menu_font_style = unfinityplus_get_opt( 'menu_font_style' );
                if ( !empty( $menu_font_style ) ) {
                    printf( '.primary-menu > li > a { font-style: %s !important; }', esc_attr($menu_font_style) );
                }
                $menu_text_transform = unfinityplus_get_opt( 'menu_text_transform' );
                if ( !empty( $menu_text_transform ) ) {
                    printf( '.primary-menu > li > a { text-transform: %s !important; }', esc_attr($menu_text_transform) );
                }
                $menu_font_size = unfinityplus_get_opt( 'menu_font_size' );
                if ( !empty( $menu_font_size ) ) {
                    printf( '.primary-menu > li > a { font-size: %s'.'px !important; }', esc_attr($menu_font_size) );
                }

                $main_menu_color = unfinityplus_get_opt( 'main_menu_color' );
                if ( !empty( $main_menu_color['regular'] ) ) {
                    printf( '.site-header-main:not(.h-fixed) .primary-menu > li > a, .site-header-main:not(.h-fixed) .site-menu-right .menu-right-item:not(.h-btn), .site-header-main:not(.h-fixed) .site-menu-right .h-social { color: %s !important; }', esc_attr($main_menu_color['regular']) );
                }
                if ( !empty( $main_menu_color['hover'] ) ) {
                    printf( '.site-header-main:not(.h-fixed) .primary-menu > li > a:hover, .site-header-main:not(.h-fixed) .site-menu-right .menu-right-item:not(.h-btn):hover, .site-header-main:not(.h-fixed) .site-menu-right .h-social:hover { color: %s !important; }', esc_attr($main_menu_color['hover']) );
                }
                if ( !empty( $main_menu_color['active'] ) ) {
                    printf( '.site-header-main:not(.h-fixed) .primary-menu > li > a.current, .site-header-main:not(.h-fixed) .primary-menu > li.current_page_item > a, .site-header-main:not(.h-fixed) .primary-menu > li.current-menu-item > a, .site-header-main:not(.h-fixed) .primary-menu > li.current_page_ancestor > a, .site-header-main:not(.h-fixed) .primary-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr($main_menu_color['active']) );
                }
                $main_menu_color_sticky = unfinityplus_get_opt( 'main_menu_color_sticky' );
                if ( !empty( $main_menu_color_sticky['regular'] ) ) {
                    printf( '.site-header-main.h-fixed .primary-menu > li > a, .site-header-main.h-fixed .site-menu-right .menu-right-item:not(.h-btn), .site-header-main.h-fixed .site-menu-right .h-social { color: %s !important; }', esc_attr($main_menu_color_sticky['regular']) );
                }
                if ( !empty( $main_menu_color_sticky['hover'] ) ) {
                    printf( '.site-header-main.h-fixed .primary-menu > li > a:hover, .site-header-main.h-fixed .site-menu-right .menu-right-item:not(.h-btn):hover, .site-header-main.h-fixed .site-menu-right .h-social:hover { color: %s !important; }', esc_attr($main_menu_color_sticky['hover']) );
                }
                if ( !empty( $main_menu_color_sticky['active'] ) ) {
                    printf( '.site-header-main.h-fixed .primary-menu > li > a.current, .site-header-main.h-fixed .primary-menu > li.current_page_item > a, .site-header-main.h-fixed .primary-menu > li.current-menu-item > a, .site-header-main.h-fixed .primary-menu > li.current_page_ancestor > a, .site-header-main.h-fixed .primary-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr($main_menu_color_sticky['active']) );
                }
                $main_menu_color_sub = unfinityplus_get_opt( 'main_menu_color_sub' );
                if ( !empty( $main_menu_color_sub['regular'] ) ) {
                    printf( '.primary-menu .sub-menu li a { color: %s !important; }', esc_attr($main_menu_color_sub['regular']) );
                }
                if ( !empty( $main_menu_color_sub['hover'] ) ) {
                    printf( '.primary-menu .sub-menu li > a:hover { color: %s !important; }', esc_attr($main_menu_color_sub['hover']) );
                }
                if ( !empty( $main_menu_color_sub['active'] ) ) {
                    printf( '.primary-menu .sub-menu li.current_page_item > a, .primary-menu .sub-menu li.current-menu-item > a, .primary-menu .sub-menu li.current_page_ancestor > a, .primary-menu .sub-menu li.current-menu-ancestor > a, .primary-menu .sub-menu li.current-menu-parent > a { color: %s !important; }', esc_attr($main_menu_color_sub['active']) );
                }
                $main_menu_line_color = unfinityplus_get_opt( 'main_menu_line_color' );
                if ( !empty( $main_menu_line_color ) ) {
                    printf( '#site-header-wrap.header-layout5 #site-header .primary-menu > li > a::before, #site-header-wrap.header-layout2 .site-header-main .primary-menu > li > a::before, #site-header-wrap.header-layout13 .site-header-main .primary-menu > li > a::before { background-color: %s !important; }', esc_attr($main_menu_line_color) );
                }
            ?>
        }
        <?php $header_layout = unfinityplus_get_opt( 'header_layout', '1' );
        $main_menu_bgcolor = unfinityplus_get_opt( 'main_menu_bgcolor' );
        if($header_layout == '8' && !empty( $main_menu_bgcolor['hover'] ) ) {
            printf( '.header-layout8 .primary-menu > li > a:hover { background-color: %s !important; }', esc_attr($main_menu_bgcolor['hover']) );
        }
        if($header_layout == '8' && !empty( $main_menu_bgcolor['active'] ) ) {
            printf( '.header-layout8 .primary-menu > li > a.current, .header-layout8 .primary-menu > li.current_page_item > a, .header-layout8 .primary-menu > li.current-menu-item > a, .header-layout8 .primary-menu > li.current_page_ancestor > a, .header-layout8 .primary-menu > li.current-menu-ancestor > a { background-color: %s !important; }', esc_attr($main_menu_bgcolor['active']) );
        }

        /* Footer */
        $footer_bg = unfinityplus_get_opt( 'footer_bg' );
        $footer_bg_color_top = unfinityplus_get_opt( 'footer_bg_color_top' );
        $footer_top_heading_color = unfinityplus_get_opt( 'footer_top_heading_color' );
        $footer_top_heading_fs = unfinityplus_get_opt( 'footer_top_heading_fs' );
        $footer_top_paddings = unfinityplus_get_opt( 'footer_top_paddings' );
        if(!empty($footer_bg['background-color'])) {
            echo '.site-layout-default .site-footer {
                margin-top: 0px;
            }';
            echo '.site-layout-default .site-footer:before {
                display: none;
            }';
        }
        if(!empty($footer_bg_color_top)) {
            echo '.site-footer:before {
                background-color: '.esc_attr( $footer_bg_color_top['rgba'] ).' !important;
            }';
        }
        if(!empty($footer_top_heading_color)) {
            echo '.top-footer .footer-widget-title {
                color: '.esc_attr( $footer_top_heading_color ).' !important;
            }';
        }
        if(!empty($footer_top_heading_fs)) {
            echo '.top-footer .footer-widget-title {
                font-size: '.esc_attr( $footer_top_heading_fs ).'px !important;
            }';
        }
        if ( isset($footer_top_paddings) && !empty($footer_top_paddings) ) {
            if(!empty($footer_top_paddings['padding-top'])) {
                echo ".site-footer {
                    padding-top:" .esc_attr($footer_top_paddings['padding-top']). " !important;
                }";
            }
            if(!empty($footer_top_paddings['padding-bottom'])) {
                echo ".site-footer .top-footer {
                    padding-bottom:" .esc_attr($footer_top_paddings['padding-bottom']). " !important;
                }";
            }
        }
        /* Colors */
        $primary_color_gradient = unfinityplus_get_opt( 'primary_color_gradient' );
        $footer_top_link_color = unfinityplus_get_opt( 'footer_top_link_color', '' );
        $footer_bottom_link_color = unfinityplus_get_opt( 'footer_bottom_link_color', '' );
        if(!empty($primary_color_gradient['from']) && !empty($primary_color_gradient['to']) && empty($footer_bottom_link_color["regular"]) && empty($footer_bottom_link_color["hover"])) {
            echo '.bottom-footer .bottom-copyright a {
                background-clip: text;
                -moz-background-clip: text;
                -webkit-background-clip: text;
                text-fill-color: transparent;
                -moz-text-fill-color: transparent;
                -webkit-text-fill-color: transparent;
                background-image: -webkit-gradient(linear, left top, right top, from('.esc_attr( $primary_color_gradient['from'] ).'), to('.esc_attr( $primary_color_gradient['to'] ).'));
                background-image: -webkit-linear-gradient(left, '.esc_attr( $primary_color_gradient['from'] ).', '.esc_attr( $primary_color_gradient['to'] ).');
                background-image: -moz-linear-gradient(left, '.esc_attr( $primary_color_gradient['from'] ).', '.esc_attr( $primary_color_gradient['to'] ).');
                background-image: -ms-linear-gradient(left, '.esc_attr( $primary_color_gradient['from'] ).', '.esc_attr( $primary_color_gradient['to'] ).');
                background-image: -o-linear-gradient(left, '.esc_attr( $primary_color_gradient['from'] ).', '.esc_attr( $primary_color_gradient['to'] ).');
                background-image: linear-gradient(left, '.esc_attr( $primary_color_gradient['from'] ).', '.esc_attr( $primary_color_gradient['to'] ).');
            }';
        }

        /* Footer */
        if(!empty($footer_top_link_color['hover'])) {

            echo '.contact-info ul li i, .site-footer .top-footer ul.menu li a::before,
            .site-footer .bottom-footer .footer-social a:hover,
            .site-footer .top-footer #ctf.ctf .ctf-author-name::before,
            .site-footer .top-footer #ctf.ctf .ctf-author-name:hover {
                color: '.esc_attr( $footer_top_link_color['hover'] ).';
            }';
        }

        /* Shop Style */
        $content_padding = unfinityplus_get_page_opt( 'content_padding' );
        if(!empty($content_padding['padding-top'])) {
            echo ".post-type-archive-product #content {
                padding-top:" .esc_attr($content_padding['padding-top']). ";
            }";
        }
        if(!empty($content_padding['padding-bottom'])) {
            echo ".post-type-archive-product #content {
                padding-bottom:" .esc_attr($content_padding['padding-bottom']). ";
            }";
        }
        $content_bg_color = unfinityplus_get_page_opt( 'content_bg_color' );
        if(!empty($content_bg_color['rgba'])) {
            echo ".post-type-archive-product #content {
                background-color:" .esc_attr($content_bg_color['rgba']). ";
            }";
        }

        /* Custom Css */
        $custom_css = unfinityplus_get_opt( 'site_css' );
        if(!empty($custom_css)) { echo esc_attr($custom_css); }

        return ob_get_clean();
    }
}

new CSS_Generator();