<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

if(class_exists('Newsletter')) {
    $forms = array_filter( (array) get_option( 'newsletter_forms', array() ) );

    $newsletter_forms = array(
        'default' => esc_html__( 'Default Form', 'unfinityplus' )
    );

    if ( $forms )
    {
        $index = 1;
        foreach ( $forms as $key => $form )
        {
            $newsletter_forms[ $key ] = sprintf( esc_html__( 'Form %s', 'unfinityplus' ), $index );
            $index ++;
        }
    }
} else {
    $newsletter_forms = '';
}

$opt_name = unfinityplus_get_opt_name();
$theme = wp_get_theme();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type'            => class_exists('CaseThemeCore') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'unfinityplus'),
    'page_title'           => esc_html__('Theme Options', 'unfinityplus'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => class_exists('CaseThemeCore') ? $theme->get('TextDomain') : '',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    'templates_path'       => class_exists('CaseThemeCore') ? casethemescore()->path('APP_DIR') . '/templates/redux/' : '',
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'unfinityplus'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id'       => 'show_page_loading',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Page Loading', 'unfinityplus'),
            'subtitle' => esc_html__('Enable page loading effect when you load site.', 'unfinityplus'),
            'default'  => false
        ),
        array(
            'id'       => 'loading_type',
            'type'     => 'select',
            'title'    => esc_html__('Loading Style', 'unfinityplus'),
            'options'  => array(
                'style1'  => esc_html__('Style 1', 'unfinityplus'),
                'style2'  => esc_html__('Style 2', 'unfinityplus'),
                'style3'  => esc_html__('Style 3', 'unfinityplus'),
                'style4'  => esc_html__('Style 4', 'unfinityplus'),
                'style5'  => esc_html__('Style 5', 'unfinityplus'),
                'style6'  => esc_html__('Style 6', 'unfinityplus'),
                'style7'  => esc_html__('Style 7', 'unfinityplus'),
                'style8'  => esc_html__('Style 8', 'unfinityplus'),
                'style9'  => esc_html__('Style 9', 'unfinityplus'),
            ),
            'default'  => 'style1',
            'required' => array( 0 => 'show_page_loading', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'smoothscroll',
            'type'     => 'switch',
            'title'    => esc_html__('Smooth Scroll', 'unfinityplus'),
            'default'  => false
        ),
        array(
            'id'       => 'rtl',
            'type'     => 'switch',
            'title'    => esc_html__('Switch RTL', 'unfinityplus'),
            'default'  => false
        ),
        array(
            'id'       => 'dev_mode',
            'type'     => 'switch',
            'title'    => esc_html__('Dev Mode (not recommended)', 'unfinityplus'),
            'description' => 'no minimize , generate css over time...',
            'default'  => false
        ),
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'unfinityplus'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/favicon.png'
            )
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'unfinityplus'),
    'icon'   => 'el-icon-website',
    'fields' => array(
        array(
            'id'       => 'header_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'unfinityplus'),
            'subtitle' => esc_html__('Select a layout for header.', 'unfinityplus'),
            'options'  => array(
                '1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
                '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
                '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
                '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
                '5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
                '6' => get_template_directory_uri() . '/assets/images/header-layout/h6.jpg',
                '7' => get_template_directory_uri() . '/assets/images/header-layout/h7.jpg',
                '8' => get_template_directory_uri() . '/assets/images/header-layout/h8.jpg',
                '9' => get_template_directory_uri() . '/assets/images/header-layout/h9.jpg',
                '10' => get_template_directory_uri() . '/assets/images/header-layout/h10.jpg',
                '11' => get_template_directory_uri() . '/assets/images/header-layout/h11.jpg',
                '12' => get_template_directory_uri() . '/assets/images/header-layout/h12.jpg',
                '13' => get_template_directory_uri() . '/assets/images/header-layout/h13.jpg',
                '14' => get_template_directory_uri() . '/assets/images/header-layout/h14.jpg',
                '15' => get_template_directory_uri() . '/assets/images/header-layout/h15.jpg',
                '16' => get_template_directory_uri() . '/assets/images/header-layout/h16.jpg',
                '17' => get_template_directory_uri() . '/assets/images/header-layout/h17.jpg',
            ),
            'default'  => '1'
        ),
        array(
            'id'           => 'h_bg_color',
            'type'         => 'color',
            'title'        => esc_html__( 'Main Background Color', 'unfinityplus' ),
            'transparent' => false
        ),
        array(
            'id'           => 'h_bg_image',
            'type'         => 'background',
            'title'        => esc_html__( 'Main Background Image', 'unfinityplus' ),
            'transparent' => false,
            'background-color' => false,
            'output'      => array('#site-header-wrap #site-header.site-header-main'),
        ),
        array(
            'id'       => 'search_on',
            'type'     => 'switch',
            'title'    => esc_html__('Search Icon', 'unfinityplus'),
            'default'  => false
        ),
        array(
            'id'       => 'social_on',
            'type'     => 'switch',
            'title'    => esc_html__('Social Icon', 'unfinityplus'),
            'default'  => false
        ),
        array(
            'id'      => 'header_social',
            'type'    => 'sorter',
            'title'   => 'Social',
            'desc'    => 'Choose which social networks are displayed and edit where they link to.',
            'options' => array(
                'enabled'  => array(
                    'facebook'  => 'Facebook', 
                    'twitter'   => 'Twitter',
                    'linkedin'  => 'Linkedin',
                ),
                'disabled' => array(
                    'google'    => 'Google',
                    'instagram' => 'Instagram',
                    'tripadvisor'     => 'Tripadvisor',
                    'youtube'   => 'Youtube', 
                    'vimeo'     => 'Vimeo', 
                    'tumblr'    => 'Tumblr',
                    'pinterest' => 'Pinterest',
                    'yelp'      => 'Yelp',
                    'skype'     => 'Skype',
                )
            ),
            'required' => array( 0 => 'social_on', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'social_target_top',
            'type'     => 'button_set',
            'title'    => esc_html__('Social Target', 'unfinityplus'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'unfinityplus'),
                '_blank' => esc_html__('Blank', 'unfinityplus'),
            ),
            'default'  => '_self',
            'required' => array( 0 => 'social_on', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'sticky_on',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky Header', 'unfinityplus'),
            'subtitle' => esc_html__('Header will be sticked when applicable.', 'unfinityplus'),
            'default'  => false
        ),
        array(
            'title' => esc_html__('Header Fancy Box', 'unfinityplus'),
            'type'  => 'slides',
            'id' => 'h_fancy_box',
            'required' => array( 0 => 'header_layout', 1 => 'equals', 2 => '4' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Top Bar', 'unfinityplus'),
    'icon'       => 'el el-resize-vertical',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'           => 'h_bg_top_color',
            'type'         => 'color',
            'title'        => esc_html__( 'Top Background Color', 'unfinityplus' ),
            'transparent' => false
        ),
        array(
            'id'           => 'h_text_top_color',
            'type'         => 'color',
            'title'        => esc_html__( 'Top Text Color', 'unfinityplus' ),
            'transparent' => false
        ),
        array(
            'id'       => 'topbar_short',
            'type'     => 'text',
            'title'    => esc_html__('Short Description', 'unfinityplus'),
            'desc'     => 'Enter short description.',
            'default'  => ''
        ),
        array(
            'id'       => 'topbar_phone',
            'type'     => 'text',
            'title'    => esc_html__('Phone', 'unfinityplus'),
            'desc'     => 'Enter phone.',
            'default'  => '',
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array(),
                    'class' => array(),
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array(),
                'span' => array(),
                'p' => array(),
                'cite' => array(),
                'div' => array(
                    'class' => array()
                ),
                'h1' => array(
                    'class' => array()
                ),
                'h2' => array(
                    'class' => array()
                ),
                'h3' => array(
                    'class' => array()
                ),
                'h4' => array(
                    'class' => array()
                ),
                'h5' => array(
                    'class' => array()
                ),
                'h6' => array(
                    'class' => array()
                ),
                'ul' => array(
                    'class' => array()
                ),
                'li' => array(),
            )
        ),
        array(
            'id'       => 'topbar_time',
            'type'     => 'text',
            'title'    => esc_html__('Time', 'unfinityplus'),
            'desc'     => 'Enter time.',
            'default'  => '',
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array(),
                    'class' => array(),
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array(),
                'span' => array(),
                'p' => array(),
                'cite' => array(),
                'div' => array(
                    'class' => array()
                ),
                'h1' => array(
                    'class' => array()
                ),
                'h2' => array(
                    'class' => array()
                ),
                'h3' => array(
                    'class' => array()
                ),
                'h4' => array(
                    'class' => array()
                ),
                'h5' => array(
                    'class' => array()
                ),
                'h6' => array(
                    'class' => array()
                ),
                'ul' => array(
                    'class' => array()
                ),
                'li' => array(),
            )
        ),
        array(
            'id'       => 'topbar_address',
            'type'     => 'text',
            'title'    => esc_html__('Address', 'unfinityplus'),
            'desc'     => 'Enter address.',
            'default'  => '',
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array(),
                    'class' => array(),
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array(),
                'span' => array(),
                'p' => array(),
                'cite' => array(),
                'div' => array(
                    'class' => array()
                ),
                'h1' => array(
                    'class' => array()
                ),
                'h2' => array(
                    'class' => array()
                ),
                'h3' => array(
                    'class' => array()
                ),
                'h4' => array(
                    'class' => array()
                ),
                'h5' => array(
                    'class' => array()
                ),
                'h6' => array(
                    'class' => array()
                ),
                'ul' => array(
                    'class' => array()
                ),
                'li' => array(),
            )
        ),
        array(
            'id'       => 'topbar_email',
            'type'     => 'text',
            'title'    => esc_html__('Email', 'unfinityplus'),
            'desc'     => 'Enter email.',
            'default'  => '',
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array(),
                    'class' => array(),
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array(),
                'span' => array(),
                'p' => array(),
                'cite' => array(),
                'div' => array(
                    'class' => array()
                ),
                'h1' => array(
                    'class' => array()
                ),
                'h2' => array(
                    'class' => array()
                ),
                'h3' => array(
                    'class' => array()
                ),
                'h4' => array(
                    'class' => array()
                ),
                'h5' => array(
                    'class' => array()
                ),
                'h6' => array(
                    'class' => array()
                ),
                'ul' => array(
                    'class' => array()
                ),
                'li' => array(),
            )
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Logo', 'unfinityplus'),
    'icon'       => 'el el-picture',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'logo_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Logo Type', 'unfinityplus'),
            'options'  => array(
                'logo-img'  => esc_html__('Image', 'unfinityplus'),
                'logo-text'  => esc_html__('Text', 'unfinityplus'),
            ),
            'default'  => 'logo-img'
        ),
        array(
            'id'      => 'logo_text',
            'type'    => 'text',
            'title'   => esc_html__('Logo Text', 'unfinityplus'),
            'default' => '',
            'required' => array( 0 => 'logo_type', 1 => 'equals', 2 => 'logo-text' ),
        ),
        array(
            'id'      => 'slogan_text',
            'type'    => 'text',
            'title'   => esc_html__('Slogan Text', 'unfinityplus'),
            'default' => '',
            'required' => array( 0 => 'logo_type', 1 => 'equals', 2 => 'logo-text' ),
        ),
        array(
            'id'       => 'logo_light',
            'type'     => 'media',
            'title'    => esc_html__('Logo Light', 'unfinityplus'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-light.png'
            ),
            'required' => array( 0 => 'logo_type', 1 => 'equals', 2 => 'logo-img' ),
            'force_output' => true
        ),
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => esc_html__('Logo Dark', 'unfinityplus'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-dark.png'
            ),
            'required' => array( 0 => 'logo_type', 1 => 'equals', 2 => 'logo-img' ),
            'force_output' => true
        ),
        array(
            'id'       => 'logo_maxh',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max height', 'unfinityplus'),
            'subtitle' => esc_html__('Set maximum height for your logo, just in case the logo is too large.', 'unfinityplus'),
            'width'    => false,
            'unit'     => 'px',
            'required' => array( 0 => 'logo_type', 1 => 'equals', 2 => 'logo-img' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Navigation', 'unfinityplus'),
    'icon'       => 'el el-lines',
    'subsection' => true,
    'fields'     => array(
        array(
            'title' => esc_html__('Menu Style First Level', 'unfinityplus'),
            'type'  => 'section',
            'id' => 'menu_style_level1',
            'indent' => true
        ),
        array(
            'id'          => 'font_menu',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Google Font', 'unfinityplus'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => false,
            'font-style'  => false,
            'font-weight'  => false,
            'text-align'  => false,
            'font-size'  => false,
            'line-height'  => false,
            'color'  => false,
            'output'      => array('.primary-menu > li > a'),
            'units'       => 'px',
        ),
        array(
            'id'       => 'menu_font_weight',
            'type'     => 'select',
            'title'    => esc_html__('Font Weight', 'unfinityplus'),
            'options'  => array(
                ''  => esc_html__('Default', 'unfinityplus'),
                '400'  => esc_html__('Normal 400', 'unfinityplus'),
                '500'  => esc_html__('Medium 500', 'unfinityplus'),
                '600'  => esc_html__('SemiBold 600', 'unfinityplus'),
                '700'  => esc_html__('Bold 700', 'unfinityplus'),
            ),
            'default'  => ''
        ),
        array(
            'id'       => 'menu_font_style',
            'type'     => 'select',
            'title'    => esc_html__('Font Style', 'unfinityplus'),
            'options'  => array(
                ''  => esc_html__('Normal', 'unfinityplus'),
                'italic'  => esc_html__('Italic', 'unfinityplus'),
            ),
            'default'  => ''
        ),
        array(
            'id'       => 'menu_font_size',
            'type'     => 'text',
            'title'    => esc_html__('Font Size', 'unfinityplus'),
            'validate' => 'numeric',
            'desc'     => 'Enter number',
            'msg'      => 'Please enter number',
            'default'  => ''
        ),
        array(
            'id'       => 'menu_text_transform',
            'type'     => 'select',
            'title'    => esc_html__('Text Transform', 'unfinityplus'),
            'options'  => array(
                ''  => esc_html__('Capitalize', 'unfinityplus'),
                'uppercase' => esc_html__('Uppercase', 'unfinityplus'),
                'lowercase'  => esc_html__('Lowercase', 'unfinityplus'),
                'initial'  => esc_html__('Initial', 'unfinityplus'),
                'inherit'  => esc_html__('Inherit', 'unfinityplus'),
                'none'  => esc_html__('None', 'unfinityplus'),
            ),
            'default'  => ''
        ),
        array(
            'id'      => 'main_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color - First Level ( Main Menu )', 'unfinityplus'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'      => 'main_menu_color_sticky',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color - First Level ( Sticky Menu )', 'unfinityplus'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'      => 'main_menu_line_color',
            'type'    => 'color',
            'title'   => esc_html__('Menu Line Color - First Level ', 'unfinityplus'),
            'default' => '',
            'transparent' => false
        ),
        array(
            'id'      => 'main_menu_color_sub',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Item Color - Sub Level', 'unfinityplus'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'id'      => 'main_menu_bgcolor',
            'type'    => 'link_color',
            'regular'    => false,
            'title'   => esc_html__('Menu Item Background Color', 'unfinityplus'),
            'default' => array(
                'hover'   => '',
                'active'   => '',
            ),
            'required' => array( 0 => 'header_layout', 1 => 'equals', 2 => '8' ),
            'force_output' => true
        ),
        array(
            'id'       => 'menu_item_hover',
            'type'     => 'select',
            'title'    => esc_html__('Menu Item Hover', 'unfinityplus'),
            'options'  => array(
                'style1'  => esc_html__('Style 1', 'unfinityplus'),
                'style2'  => esc_html__('Style 2', 'unfinityplus'),
            ),
            'default'  => 'style1',
            'required' => array( 0 => 'header_layout', 1 => 'equals', 2 => '7' ),
            'force_output' => true
        ),
        array(
            'title' => esc_html__('Button Navigation', 'unfinityplus'),
            'type'  => 'section',
            'id' => 'button_navigation',
            'indent' => true
        ),
        array(
            'id'       => 'h_btn_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Show/Hide Button', 'unfinityplus'),
            'options'  => array(
                'show'  => esc_html__('Show', 'unfinityplus'),
                'hide'  => esc_html__('Hide', 'unfinityplus')
            ),
            'default'  => 'show',
        ),
        array(
            'id' => 'h_btn_text',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'unfinityplus'),
            'default' => '',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'h_btn_link_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Link Type', 'unfinityplus'),
            'options'  => array(
                'page'  => esc_html__('Page', 'unfinityplus'),
                'custom'  => esc_html__('Custom', 'unfinityplus')
            ),
            'default'  => 'page',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'    => 'h_btn_link',
            'type'  => 'select',
            'title' => esc_html__( 'Page Link', 'unfinityplus' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'page' ),
            'force_output' => true
        ),
        array(
            'id' => 'h_btn_link_custom',
            'type' => 'text',
            'title' => esc_html__('Custom Link', 'unfinityplus'),
            'default' => '',
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
        array(
            'id'       => 'h_btn_target',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Target', 'unfinityplus'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'unfinityplus'),
                '_blank'  => esc_html__('Blank', 'unfinityplus')
            ),
            'default'  => '_self',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mobile', 'unfinityplus'),
    'icon'       => 'el el-iphone-home',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'           => 'h_bg_color_mobile',
            'type'         => 'color',
            'title'        => esc_html__( 'Header Background Color', 'unfinityplus' ),
            'transparent' => false,
        ),
        array(
            'id'           => 'nav_icon_mobile',
            'type'         => 'color',
            'title'        => esc_html__( 'Navigation Icon Color', 'unfinityplus' ),
            'transparent' => false,
        ),
        array(
            'id'       => 'search_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Search', 'unfinityplus'),
            'default'  => true
        ),
        array(
            'id'       => 'social_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Social', 'unfinityplus'),
            'default'  => true
        ),
        array(
            'id'       => 'button_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Button Navigation', 'unfinityplus'),
            'default'  => true
        ),
    )
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'unfinityplus'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array(
        array(
            'id'       => 'ptitle_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Displayed', 'unfinityplus'),
            'options'  => array(
                'show'  => esc_html__('Show', 'unfinityplus'),
                'hidden'  => esc_html__('Hidden', 'unfinityplus'),
            ),
            'default'  => 'hidden'
        ),

        array(
            'id'       => 'ptitle_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'unfinityplus'),
            'subtitle' => esc_html__('Page title background color.', 'unfinityplus'),
            'output'   => array('#pagetitle'),
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_paddings',
            'type'     => 'spacing',
            'title'    => esc_html__('Content Paddings', 'unfinityplus'),
            'subtitle' => esc_html__('Content page title paddings.', 'unfinityplus'),
            'mode'     => 'padding',
            'units'    => array('em', 'px', '%'),
            'top'      => true,
            'right'    => false,
            'bottom'   => true,
            'left'     => false,
            'output'   => array('#pagetitle'),
            'default'  => array(
                'top'    => '',
                'right'  => '',
                'bottom' => '',
                'left'   => '',
                'units'  => 'px',
            ),
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_content_align',
            'type'     => 'button_set',
            'title'    => esc_html__('Content Align', 'unfinityplus'),
            'options'  => array(
                'left'  => esc_html__('Left', 'unfinityplus'),
                'center'  => esc_html__('Center', 'unfinityplus'),
                'right' => esc_html__('Right', 'unfinityplus'),
            ),
            'default'  => 'center',
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_color',
            'type'     => 'color',
            'title'    => esc_html__('Title Color', 'unfinityplus'),
            'subtitle' => esc_html__('Page title color.', 'unfinityplus'),
            'output'   => array('#pagetitle h1.page-title'),
            'default'  => '',
            'transparent' => false,
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_breadcrumb_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Breadcrumb', 'unfinityplus'),
            'options'  => array(
                'show'  => esc_html__('Show', 'unfinityplus'),
                'hidden'  => esc_html__('Hidden', 'unfinityplus'),
            ),
            'default'  => 'hidden',
            'required' => array( 0 => 'ptitle_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'          => 'breadcrumb_color',
            'type'        => 'color',
            'title'       => esc_html__('Breadcrumb Color', 'unfinityplus'),
            'transparent' => false,
            'default'     => '',
            'output'    => array('.ct-breadcrumb'),
            'required'     => array( 0 => 'ptitle_breadcrumb_on', 1 => '=', 2 => 'show' ),
            'force_output' => true
        ),
    )
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Content', 'unfinityplus'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array(
        array(
            'id'       => 'content_bg_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Background Color', 'unfinityplus'),
            'subtitle' => esc_html__('Content background color.', 'unfinityplus'),
            'output' => array('background-color' => '#content, .site-layout-default .site-footer:before')
        ),
        array(
            'id'             => 'content_padding',
            'type'           => 'spacing',
            'output'         => array('#content'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Content Padding', 'unfinityplus'),
            'desc'           => esc_html__('Default: Top-85px, Bottom-110px', 'unfinityplus'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            )
        ),
        array(
            'id'      => 'search_field_placeholder',
            'type'    => 'text',
            'title'   => esc_html__('Search Form - Text Placeholder', 'unfinityplus'),
            'default' => '',
            'desc'           => esc_html__('Default: Search Keywords...', 'unfinityplus'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Archive', 'unfinityplus'),
    'icon'       => 'el-icon-list',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'archive_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'unfinityplus'),
            'subtitle' => esc_html__('Select a sidebar position for blog home, archive, search...', 'unfinityplus'),
            'options'  => array(
                'left'  => esc_html__('Left', 'unfinityplus'),
                'right' => esc_html__('Right', 'unfinityplus'),
                'none'  => esc_html__('Disabled', 'unfinityplus')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'archive_author_on',
            'title'    => esc_html__('Author', 'unfinityplus'),
            'subtitle' => esc_html__('Show author name on each post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_date_on',
            'title'    => esc_html__('Date', 'unfinityplus'),
            'subtitle' => esc_html__('Show date posted on each post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_categories_on',
            'title'    => esc_html__('Categories', 'unfinityplus'),
            'subtitle' => esc_html__('Show category names on each post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_comments_on',
            'title'    => esc_html__('Comments', 'unfinityplus'),
            'subtitle' => esc_html__('Show comments count on each post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true,
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'unfinityplus'),
    'icon'       => 'el-icon-file-edit',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'post_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'unfinityplus'),
            'subtitle' => esc_html__('Select a sidebar position', 'unfinityplus'),
            'options'  => array(
                'left'  => esc_html__('Left', 'unfinityplus'),
                'right' => esc_html__('Right', 'unfinityplus'),
                'none'  => esc_html__('Disabled', 'unfinityplus')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'post_author_on',
            'title'    => esc_html__('Author', 'unfinityplus'),
            'subtitle' => esc_html__('Show author name on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_date_on',
            'title'    => esc_html__('Date', 'unfinityplus'),
            'subtitle' => esc_html__('Show date on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => false
        ),
        array(
            'id'       => 'post_categories_on',
            'title'    => esc_html__('Categories', 'unfinityplus'),
            'subtitle' => esc_html__('Show category names on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_comments_on',
            'title'    => esc_html__('Comments', 'unfinityplus'),
            'subtitle' => esc_html__('Show comments count on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_social_share_on',
            'title'    => esc_html__('Social Share', 'unfinityplus'),
            'subtitle' => esc_html__('Show social share on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'post_comments_form_on',
            'title'    => esc_html__('Comments Form', 'unfinityplus'),
            'subtitle' => esc_html__('Show comments form on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_feature_image_on',
            'title'    => esc_html__('Feature Image', 'unfinityplus'),
            'subtitle' => esc_html__('Show feature image on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_author_info',
            'title'    => esc_html__('Author Info', 'unfinityplus'),
            'subtitle' => esc_html__('Show author info on single post.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => false
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Services', 'unfinityplus'),
    'icon'       => 'el el-cog',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'      => 'services_slug',
            'type'    => 'text',
            'title'   => esc_html__('Slug', 'unfinityplus'),
            'default' => '',
            'subtitle' => esc_html__('The slug name cannot be the same as a page name. Make sure to regenertate permalinks, after making changes.', 'unfinityplus'),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Portfolio', 'unfinityplus'),
    'icon'       => 'el el-briefcase',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'portfolio_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Portfolio Type', 'unfinityplus'),
            'options'  => array(
                'info'  => esc_html__('Sidebar Info', 'unfinityplus'),
                'full'  => esc_html__('Full Width Content', 'unfinityplus'),
            ),
            'default'  => 'info'
        ),
        array(
            'id'      => 'portfolio_slug',
            'type'    => 'text',
            'title'   => esc_html__('Slug', 'unfinityplus'),
            'default' => '',
            'subtitle' => esc_html__('The slug name cannot be the same as a page name. Make sure to regenertate permalinks, after making changes.', 'unfinityplus'),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Extra Post Type', 'unfinityplus'),
    'icon'       => 'el el-braille',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'pt_sermons',
            'title'    => esc_html__('Sermons', 'unfinityplus'),
            'subtitle' => esc_html__('Post type on Church demo.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'pt_event',
            'title'    => esc_html__('Event', 'unfinityplus'),
            'subtitle' => esc_html__('Post type on Church demo.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'pt_causes',
            'title'    => esc_html__('Causes', 'unfinityplus'),
            'subtitle' => esc_html__('Post type on Church demo.', 'unfinityplus'),
            'type'     => 'switch',
            'default'  => false,
        ),
    )
));

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'unfinityplus'),
    'icon'   => 'el el-website',
    'fields' => array(
        array(
            'id'       => 'footer_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'unfinityplus'),
            'subtitle' => esc_html__('Select a layout for upper footer area.', 'unfinityplus'),
            'options'  => array(
                '0' => get_template_directory_uri() . '/assets/images/footer-layout/f0.jpg',
                '1' => get_template_directory_uri() . '/assets/images/footer-layout/f1.jpg',
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'back_totop_on',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Button', 'unfinityplus'),
            'subtitle' => esc_html__('Show back to top button when scrolled down.', 'unfinityplus'),
            'default'  => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Footer Top', 'unfinityplus'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'footer_top_column',
            'type'     => 'button_set',
            'title'    => esc_html__('Columns', 'unfinityplus'),
            'options'  => array(
                '2'  => esc_html__('2 Column', 'unfinityplus'),
                '3'  => esc_html__('3 Column', 'unfinityplus'),
                '4'  => esc_html__('4 Column', 'unfinityplus'),
            ),
            'default'  => '4',
        ),
        array(
            'id'       => 'column_width_change',
            'type'     => 'button_set',
            'title'    => esc_html__('Column Width Change', 'unfinityplus'),
            'options'  => array(
                'yes'  => esc_html__('Yes', 'unfinityplus'),
                'no'  => esc_html__('No', 'unfinityplus'),
            ),
            'default'  => 'yes',
            'required' => array( 0 => 'footer_top_column', 1 => 'equals', 2 => '4' ),
            'force_output' => true
        ),
        array(
            'id'       => 'footer_top_paddings',
            'type'     => 'spacing',
            'title'    => esc_html__('Paddings', 'unfinityplus'),
            'subtitle' => esc_html__('Footer top paddings.', 'unfinityplus'),
            'mode'     => 'padding',
            'units'    => array('px'),
            'right'    => false,
            'left'     => false,
            'default'  => array(
                'padding-top'    => '',
                'padding-bottom' => ''
            ),
        ),
        array(
            'id'       => 'footer_top_logo',
            'type'     => 'media',
            'title'    => esc_html__('Logo', 'unfinityplus'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-footer.png'
            )
        ),
        array(
            'id'       => 'footer_top_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background Color', 'unfinityplus'),
            'subtitle' => esc_html__('Footer top background color.', 'unfinityplus'),
            'default'  => '',
            'output'   => array('.site-footer .top-footer'),
            'background-repeat' => false,
            'background-attachment' => false,
            'background-position' => false,
            'background-image' => false,
            'background-clip' => false,
            'background-origin' => false,
            'background-size' => false,
        ),
        array(
            'id'    => 'footer_top_color',
            'type'  => 'color',
            'title' => esc_html__('Text Color', 'unfinityplus'),
            'output'   => array('body .site-footer .top-footer')
        ),
        array(
            'id'      => 'footer_top_link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Links Color', 'unfinityplus'),
            'regular' => true,
            'hover'   => true,
            'active'  => false,
            'visited' => false,
            'output'  => array('body .site-footer .top-footer  a'),
        ),
        array(
            'title' => esc_html__('Widget Title', 'unfinityplus'),
            'type'  => 'section',
            'id' => 'footer_wg_title',
            'indent' => true,
        ),
        array(
            'id'    => 'footer_top_heading_color',
            'type'  => 'color',
            'title' => esc_html__('Title Color', 'unfinityplus'),
        ),
        array(
            'id'       => 'footer_top_heading_fs',
            'type'     => 'text',
            'title'    => esc_html__('Font Size', 'unfinityplus'),
            'validate' => 'numeric',
            'desc'     => 'Enter number',
            'msg'      => 'Please enter number',
            'default'  => ''
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Footer Bottom', 'unfinityplus'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'bottom_style',
            'type'     => 'button_set',
            'title'    => esc_html__('Style', 'unfinityplus'),
            'options'  => array(
                'dark'  => esc_html__('Dark', 'unfinityplus'),
                'light' => esc_html__('Light', 'unfinityplus'),
            ),
            'default'  => 'dark',
        ),
        array(
            'id'       => 'footer_bottom_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background Color', 'unfinityplus'),
            'subtitle' => esc_html__('Footer bottom background color.', 'unfinityplus'),
            'default'  => '',
            'output'   => array('.site-footer .bottom-footer'),
            'background-repeat' => false,
            'background-attachment' => false,
            'background-position' => false,
            'background-image' => false,
            'background-clip' => false,
            'background-origin' => false,
            'background-size' => false,
        ),
        array(
            'id'    => 'footer_bottom_color',
            'type'  => 'color',
            'title' => esc_html__('Text Color', 'unfinityplus'),
            'output'   => array('body .site-footer .bottom-footer')
        ),
        array(
            'id'      => 'footer_bottom_link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Links Color', 'unfinityplus'),
            'regular' => true,
            'hover'   => true,
            'active'  => false,
            'visited' => false,
            'output'  => array('body .site-footer .bottom-footer  a'),
        ),
        array(
            'id'=>'footer_copyright',
            'type' => 'textarea',
            'title' => esc_html__('Copyright', 'unfinityplus'),
            'validate' => 'html_custom',
            'default' => '',
            'subtitle' => esc_html__('Custom HTML Allowed: a,br,em,strong,span,p,div,h1->h6', 'unfinityplus'),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array(),
                    'target' => array(),
                    'class' => array(),
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array(),
                'span' => array(),
                'p' => array(),
                'div' => array(
                    'class' => array()
                ),
                'h1' => array(
                    'class' => array()
                ),
                'h2' => array(
                    'class' => array()
                ),
                'h3' => array(
                    'class' => array()
                ),
                'h4' => array(
                    'class' => array()
                ),
                'h5' => array(
                    'class' => array()
                ),
                'h6' => array(
                    'class' => array()
                ),
                'ul' => array(
                    'class' => array()
                ),
                'li' => array(),
            )
        ),
        array(
            'id'      => 'footer_bottom_social',
            'type'    => 'sorter',
            'title'   => 'Social',
            'desc'    => 'Choose which social networks are displayed and edit where they link to.',
            'options' => array(
                'enabled'  => array(
                    'facebook'  => 'Facebook', 
                    'twitter'   => 'Twitter',
                    'linkedin'  => 'Linkedin',
                    'google'    => 'Google',
                    'instagram' => 'Instagram',
                ),
                'disabled' => array(
                    'tripadvisor'     => 'Tripadvisor',
                    'youtube'   => 'Youtube', 
                    'vimeo'     => 'Vimeo', 
                    'tumblr'    => 'Tumblr',
                    'pinterest' => 'Pinterest',
                    'yelp'      => 'Yelp',
                    'skype'     => 'Skype',
                )
            ),
        ),
        array(
            'id'       => 'social_target_bottom',
            'type'     => 'button_set',
            'title'    => esc_html__('Social Target', 'unfinityplus'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'unfinityplus'),
                '_blank' => esc_html__('Blank', 'unfinityplus'),
            ),
            'default'  => '_self',
        ),
        array(
            'id'      => 'social_label',
            'type'    => 'text',
            'title'   => esc_html__('Social Label', 'unfinityplus'),
            'default' => 'Follow us:',
        ),
    )
));


/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'unfinityplus'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'unfinityplus'),
            'transparent' => false,
            'default'     => '#b09991'
        ),
        array(
            'id'          => 'primary_color_gradient',
            'type'        => 'color_gradient',
            'title'       => esc_html__('Primary Color Gradient', 'unfinityplus'),
            'transparent' => false,
            'default'  => array(
                'from' => '',
                'to'   => '', 
            ),
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'unfinityplus'),
            'transparent' => false,
            'default'     => '#000'
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => __('Link Colors', 'unfinityplus'),
            'default' => array(
                'regular' => '#b09991',
                'hover'   => '#927e77',
                'active'  => '#927e77'
            ),
            'output'  => array('a')
        )
    )
));

/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
$custom_font_selectors_1 = Redux::getOption($opt_name, 'custom_font_selectors_1');
$custom_font_selectors_1 = !empty($custom_font_selectors_1) ? explode(',', $custom_font_selectors_1) : array();
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'unfinityplus'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'          => 'font_main',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'output'      => array('body'),
            'units'       => 'px',
        ),
        array(
            'id'          => 'font_h1',
            'type'        => 'typography',
            'title'       => esc_html__('H1', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font for all H1 tags of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h1', '.h1', '.text-heading'),
            'units'       => 'px',
        ),
        array(
            'id'          => 'font_h2',
            'type'        => 'typography',
            'title'       => esc_html__('H2', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font for all H2 tags of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h2', '.h2'),
            'units'       => 'px',
        ),
        array(
            'id'          => 'font_h3',
            'type'        => 'typography',
            'title'       => esc_html__('H3', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font for all H3 tags of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h3', '.h3'),
            'units'       => 'px',
        ),
        array(
            'id'          => 'font_h4',
            'type'        => 'typography',
            'title'       => esc_html__('H4', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font for all H4 tags of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h4', '.h4'),
            'units'       => 'px',
        ),
        array(
            'id'          => 'font_h5',
            'type'        => 'typography',
            'title'       => esc_html__('H5', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font for all H5 tags of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h5', '.h5'),
            'units'       => 'px',
        ),
        array(
            'id'          => 'font_h6',
            'type'        => 'typography',
            'title'       => esc_html__('H6', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the default font for all H6 tags of your website.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h6', '.h6'),
            'units'       => 'px',
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Fonts Selectors', 'unfinityplus'),
    'icon'       => 'el el-fontsize',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'custom_font_1',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Font', 'unfinityplus'),
            'subtitle'    => esc_html__('This will be the font that applies to the class selector.', 'unfinityplus'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => $custom_font_selectors_1,
            'units'       => 'px',

        ),
        array(
            'id'       => 'custom_font_selectors_1',
            'type'     => 'textarea',
            'title'    => esc_html__('CSS Selectors', 'unfinityplus'),
            'subtitle' => esc_html__('Add class selectors to apply above font.', 'unfinityplus'),
            'validate' => 'no_html'
        )
    )
));

/* Social Media */
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Social Media', 'unfinityplus'),
    'icon'       => 'el el-twitter',
    'subsection' => false,
    'fields'     => array(
        array(
            'id'      => 'social_facebook_url',
            'type'    => 'text',
            'title'   => esc_html__('Facebook URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_twitter_url',
            'type'    => 'text',
            'title'   => esc_html__('Twitter URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_inkedin_url',
            'type'    => 'text',
            'title'   => esc_html__('Inkedin URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_rss_url',
            'type'    => 'text',
            'title'   => esc_html__('Rss URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_instagram_url',
            'type'    => 'text',
            'title'   => esc_html__('Instagram URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_google_url',
            'type'    => 'text',
            'title'   => esc_html__('Google URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_skype_url',
            'type'    => 'text',
            'title'   => esc_html__('Skype URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_pinterest_url',
            'type'    => 'text',
            'title'   => esc_html__('Pinterest URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_vimeo_url',
            'type'    => 'text',
            'title'   => esc_html__('Vimeo URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_youtube_url',
            'type'    => 'text',
            'title'   => esc_html__('Youtube URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_yelp_url',
            'type'    => 'text',
            'title'   => esc_html__('Yelp URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_tumblr_url',
            'type'    => 'text',
            'title'   => esc_html__('Tumblr URL', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'social_tripadvisor_url',
            'type'    => 'text',
            'title'   => esc_html__('Tripadvisor URL', 'unfinityplus'),
            'default' => '',
        ),
    )
));

/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'unfinityplus'),
        'icon'   => 'el el-shopping-cart',
        'fields' => array(
            array(
                'id'       => 'sidebar_shop',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Position', 'unfinityplus'),
                'subtitle' => esc_html__('Select a sidebar position for archive shop.', 'unfinityplus'),
                'options'  => array(
                    'left'  => esc_html__('Left', 'unfinityplus'),
                    'right' => esc_html__('Right', 'unfinityplus'),
                    'none'  => esc_html__('Disabled', 'unfinityplus')
                ),
                'default'  => 'right'
            ),
            array(
                'title' => esc_html__('Products displayed per page', 'unfinityplus'),
                'id' => 'product_per_page',
                'type' => 'slider',
                'subtitle' => esc_html__('Number product to show', 'unfinityplus'),
                'default' => 9,
                'min'  => 6,
                'step' => 1,
                'max' => 50,
                'display_value' => 'text'
            ),
            array(
                'id'       => 'shop_content_padding',
                'type'     => 'spacing',
                'title'    => esc_html__('Content Paddings', 'unfinityplus'),
                'subtitle' => esc_html__('Content paddings.', 'unfinityplus'),
                'mode'     => 'padding',
                'units'    => array('em', 'px', '%'),
                'top'      => true,
                'right'    => false,
                'bottom'   => true,
                'left'     => false,
                'output'   => array('.woocommerce #content, .woocommerce-page #content'),
                'default'  => array(
                    'top'    => '',
                    'right'  => '',
                    'bottom' => '',
                    'left'   => '',
                    'units'  => 'px',
                )
            ),
        
        )
    ));
}

/* 404 Page /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('404 Page', 'unfinityplus'),
    'icon'   => 'el-cog-alt el',
    'fields' => array(
        array(
            'id'       => 'title_404_page',
            'type'     => 'text',
            'title'    => esc_html__('Title', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'      => 'desc_404_page',
            'type'    => 'textarea',
            'title'   => esc_html__('Description', 'unfinityplus'),
            'default' => '',
        ),
        array(
            'id'       => 'btn_text_404_page',
            'type'     => 'text',
            'title'    => esc_html__('Button Text', 'unfinityplus'),
            'default' => '',
        ),
    ),
));

/* Custom Code /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom Code', 'unfinityplus'),
    'icon'   => 'el-icon-edit',
    'fields' => array(

        array(
            'id'       => 'site_header_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Header Custom Codes', 'unfinityplus'),
            'subtitle' => esc_html__('It will insert the code to wp_head hook.', 'unfinityplus'),
        ),
        array(
            'id'       => 'site_footer_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Footer Custom Codes', 'unfinityplus'),
            'subtitle' => esc_html__('It will insert the code to wp_footer hook.', 'unfinityplus'),
        ),

    ),
));

/* Custom CSS /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom CSS', 'unfinityplus'),
    'icon'   => 'el-icon-adjust-alt',
    'fields' => array(

        array(
            'id'   => 'customcss',
            'type' => 'info',
            'desc' => esc_html__('Custom CSS', 'unfinityplus')
        ),

        array(
            'id'       => 'site_css',
            'type'     => 'ace_editor',
            'title'    => esc_html__('CSS Code', 'unfinityplus'),
            'subtitle' => esc_html__('Advanced CSS Options. You can paste your custom CSS Code here.', 'unfinityplus'),
            'mode'     => 'css',
            'validate' => 'css',
            'theme'    => 'chrome',
            'default'  => ""
        ),

    ),
));