<?php
/**
 * Template part for displaying results in search pages
 *
 * @package UnfinityPlus
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-hentry archive' ); ?>>

    <div class="entry-featured">
        <?php
            if (has_post_thumbnail()) {
                echo '<div class="post-image">'; ?>
                    <a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_post_thumbnail('large'); ?></a>
                <?php echo '</div>';
            }
        ?>
    </div><!-- .entry-featured -->
    <div class="entry-body">
        <div class="entry-holder">
            <?php unfinityplus_archive_meta(); ?>
            <h2 class="entry-title"><a href="<?php echo esc_url( get_permalink()); ?>"><?php the_title(); ?></a></h2>
            <div class="entry-time"><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' '.esc_html__('ago', 'unfinityplus'); ?></div>
        </div>
        <div class="entry-content">
            <?php
                unfinityplus_entry_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <div class="entry-more">
            <a class="btn-readmore" href="<?php echo esc_url( get_permalink()); ?>"><?php echo esc_html__('Read More', 'unfinityplus')?></a>
        </div>
    </div>
</article><!-- #post -->