<?php
/**
 * Template part for displaying site branding
 */

$logo_type = unfinityplus_get_opt( 'logo_type', 'logo-img' );

$logo_text = unfinityplus_get_opt( 'logo_text' );
$slogan_text = unfinityplus_get_opt( 'slogan_text' );

$logo = unfinityplus_get_opt( 'logo', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
$logo_url = $logo['url'];

$logo_light = unfinityplus_get_opt( 'logo_light', array( 'url' => get_template_directory_uri().'/assets/images/logo-light.png', 'id' => '' ) );
$logo_light_url = $logo_light['url'];

$custom_header = unfinityplus_get_page_opt( 'custom_header', false );
$logo_light_page = unfinityplus_get_page_opt( 'logo_light' );
$logo_dark_page = unfinityplus_get_page_opt( 'logo_dark' );

if($custom_header == true && !empty($logo_light_page['url'])) {
    $logo_light_url = $logo_light_page['url'];
}

if($custom_header == true && !empty($logo_dark_page['url'])) {
    $logo_url = $logo_dark_page['url'];
}

if($logo_type == 'logo-img') {
    if ($logo_url || $logo_light_url)
    {
        if ( is_front_page() && is_home() ) {
            printf('<h1 class="site-title" style="display: none;">%1$s</h1>', esc_attr( get_bloginfo( 'name' ) ));
        }
        printf(
            '<a class="logo-light" href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="'.esc_attr__('Logo Light', 'unfinityplus').'"/></a>',
            esc_url( home_url( '/' ) ),
            esc_attr( get_bloginfo( 'name' ) ),
            esc_url( $logo_light_url )
        );
        printf(
            '<a class="logo-dark" href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="'.esc_attr__('Logo Dark', 'unfinityplus').'"/></a>',
            esc_url( home_url( '/' ) ),
            esc_attr( get_bloginfo( 'name' ) ),
            esc_url( $logo_url )
        );
        if ( is_front_page() && is_home() ) {
            printf('</h1>');
        }
    }
    else
    {
        printf(
            '<a class="logo-light" href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="'.esc_attr__('Logo', 'unfinityplus').'"/></a>',
            esc_url( home_url( '/' ) ),
            esc_attr( get_bloginfo( 'name' ) ),
            esc_url( get_template_directory_uri().'/assets/images/logo-light.png' )
        );
    }
} else {
    if(!empty($logo_text)) {
        printf(
        '<h1 class="site-title"><a href="%1$s" rel="home">%2$s</a></h1>',
            esc_url( home_url( '/' ) ),
            esc_html( $logo_text )
        );
    } else {
        printf(
        '<h1 class="site-title"><a href="%1$s" rel="home">%2$s</a></h1>',
            esc_url( home_url( '/' ) ),
            esc_html( get_bloginfo( 'name' ) )
        );
    }
    if(!empty($slogan_text)) {
        printf( '<div class="site-description">%s</div>', esc_attr($slogan_text) );
    } else {
        $description = get_bloginfo( 'description', 'display' );
        if ( $description || is_customize_preview() )
        {
            printf( '<div class="site-description">%s</div>', esc_attr($description) );
        }
    }
}