<?php
/**
 * Template part for displaying default header layout
 */
$search_on = unfinityplus_get_opt( 'search_on', false );
$social_on = unfinityplus_get_opt( 'social_on', false );
$sticky_on = unfinityplus_get_opt( 'sticky_on', false );
$search_mobile = unfinityplus_get_opt( 'search_mobile', true );
$social_mobile = unfinityplus_get_opt( 'social_mobile', true );
$button_mobile = unfinityplus_get_opt( 'button_mobile', true );
$h_btn_on = unfinityplus_get_opt( 'h_btn_on', 'show' );
$h_btn_link_type = unfinityplus_get_opt( 'h_btn_link_type', 'page' );
$h_btn_text = unfinityplus_get_opt( 'h_btn_text' );
$h_btn_link = unfinityplus_get_opt( 'h_btn_link' );
$h_btn_link_custom = unfinityplus_get_opt( 'h_btn_link_custom' );
$h_btn_target = unfinityplus_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}
?>
<header id="masthead" class="site-header">
    <div id="site-header-wrap" class="header-layout12 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } else { echo 'no-sticky'; } ?>">
        <div id="site-header" class="site-header-main">
            <div class="container">
                <div class="row">
                    <div class="site-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="site-navigation">
                        <nav class="main-navigation">
                            <div class="main-navigation-inner">
                                <div class="menu-mobile-close"><i class="zmdi zmdi-close"></i></div>
                                <?php if($search_mobile) { unfinityplus_header_mobile_search(); } ?>
                                <?php if($button_mobile && $h_btn_on == 'show' && !empty($h_btn_text)) { ?>
                                    <div class="menu-mobile-button">
                                        <a href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>" class="h-btn"><?php echo esc_attr( $h_btn_text ); ?></a>
                                    </div>
                                <?php } ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                                <?php if($social_mobile) { ?><div class="social-mobile"><?php unfinityplus_header_social_icon(); ?></div><?php } ?>
                            </div>
                        </nav>
                        <div class="site-menu-right d-none d-lg-block">
                            <?php if($search_on) : ?>
                                <span class="menu-right-item h-btn-search"><i class="fa fa-search"></i></span>
                            <?php endif; ?>
                            <?php if($social_on) : ?>
                                <?php unfinityplus_header_social_icon(); ?>
                            <?php endif; ?>
                            <?php if($h_btn_on == 'show' && !empty($h_btn_text)) : ?>
                                <a href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>" class="menu-right-item h-btn"><?php echo esc_attr( $h_btn_text ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="menu-mobile-overlay"></div>
                </div>
            </div>
            <div id="main-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>
    </div>
</header>