<?php
/**
 * Template part for displaying default header layout
 */
$search_on = unfinityplus_get_opt( 'search_on', false );
$social_on = unfinityplus_get_opt( 'social_on', false );
$sticky_on = unfinityplus_get_opt( 'sticky_on', false );
$topbar_phone = unfinityplus_get_opt( 'topbar_phone' );
$topbar_time = unfinityplus_get_opt( 'topbar_time' );
$search_mobile = unfinityplus_get_opt( 'search_mobile', true );
$social_mobile = unfinityplus_get_opt( 'social_mobile', true );
?>
<header id="masthead" class="site-header">
    <div id="site-header-wrap" class="header-layout2 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } else { echo 'no-sticky'; } ?>">
        <div id="site-topbar">
            <div class="container">
                <div class="row">
                    <ul class="site-topbar-contact">
                        <?php if(!empty($topbar_phone)) : ?>
                            <li><i class="fa fa-phone-square"></i><?php echo wp_kses_post( $topbar_phone ); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($topbar_time)) : ?>
                            <li><i class="fa fa-clock-o"></i><?php echo wp_kses_post( $topbar_time ); ?></li>
                        <?php endif; ?>
                    </ul>
                    <?php do_action('wpml_add_language_selector'); ?>
                </div>
            </div>
        </div>
        <div id="site-header" class="site-header-main">
            <div class="container">
                <div class="row">
                    <div class="site-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="site-navigation">
                        <nav class="main-navigation">
                            <div class="main-navigation-inner">
                                <div class="menu-mobile-close"><i class="zmdi zmdi-close"></i></div>
                                <?php if($search_mobile) { unfinityplus_header_mobile_search(); } ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                                <?php if($social_mobile) { ?><div class="social-mobile"><?php unfinityplus_header_social_icon(); ?></div><?php } ?>
                            </div>
                        </nav>
                        <div class="site-menu-right d-none d-lg-block">
                            <?php if($search_on) : ?>
                                <span class="menu-right-item h-btn-search"><i class="fa fa-search"></i></span>
                            <?php endif; ?>
                            <?php if($social_on) : ?>
                                <?php unfinityplus_header_social_icon(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="menu-mobile-overlay"></div>
                </div>
            </div>
            <div id="main-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>
    </div>
</header>