<?php
vc_map(array(
    'name' => 'Banner',
    'base' => 'cms_banner',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Banner Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_banner',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'std' => 'cms_banner.php',
            'group' => esc_html__('Template', 'unfinityplus'),
        ),

        /* Title */
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Title', 'unfinityplus'),
            'param_name' => 'title',
            'description' => 'Enter title.',
        ),

        /* Description */
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Description', 'unfinityplus'),
            'param_name' => 'description',
            'description' => 'Enter description.',
        ),

        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'unfinityplus' ),
            'param_name' => 'banner_image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Image Position', 'unfinityplus'),
            'param_name' => 'img_pos',
            'value' => array(
                'Left' => 'img-left',
                'Right' => 'img-right',
            ),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_banner extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>