<?php
vc_map(array(
    'name' => 'Button',
    'base' => 'cms_button',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Button Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Text', 'unfinityplus' ),
            'param_name' => 'button_text',
            'value' => '',
            'admin_label' => true,
            'group' => esc_html__('Button Settings', 'unfinityplus')
        ),
        array(
            'type' => 'vc_link',
            'class' => '',
            'heading' => esc_html__('Link', 'unfinityplus'),
            'param_name' => 'button_link',
            'value' => '',
            'group' => esc_html__('Button Settings', 'unfinityplus')
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Style', 'unfinityplus'),
            'param_name' => 'button_style',
            'value' => array(
                'Default' => 'btn-default',
                'Default Hover White Dark' => 'btn-default hover-white-dark',
                'Gradient' => 'btn-gradient',
                'Outline Gradient' => 'btn-outline-gradient',
                'Secondary' => 'btn-secondary',
                'Primary Outline' => 'btn-primary-outline',
                'Primary Outline Dashed' => 'btn-primary-outline outline-dashed',
                'Primary White' => 'btn-primary-white',
                'Primary Secondary' => 'btn-primary-secondary',
                'Primary Secondary Hover White' => 'btn-primary-secondary hover-white',
                'Primary Secondary Outline' => 'btn-ps-outline',
            ),
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Size', 'unfinityplus'),
            'param_name' => 'button_size',
            'value' => array(
                'Default' => 'size-default',
                'Large' => 'size-lg',
            ),
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Align Large', 'unfinityplus'),
            'param_name' => 'align_lg',
            'value' => array(
                'Left' => 'align-left',
                'Center' => 'align-center',
                'Right' => 'align-right',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Align Medium', 'unfinityplus'),
            'param_name' => 'align_md',
            'value' => array(
                'Left' => 'align-left-md',
                'Center' => 'align-center-md',
                'Right' => 'align-right-md',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Align Small', 'unfinityplus'),
            'param_name' => 'align_sm',
            'value' => array(
                'Left' => 'align-left-sm',
                'Center' => 'align-center-sm',
                'Right' => 'align-right-sm',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Align Mini', 'unfinityplus'),
            'param_name' => 'align_xs',
            'value' => array(
                'Left' => 'align-left-xs',
                'Center' => 'align-center-xs',
                'Right' => 'align-right-xs',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        /* Padding */
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Padding Top', 'unfinityplus'),
            'param_name' => 'padding_top',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Padding Right', 'unfinityplus'),
            'param_name' => 'padding_right',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Padding Bottom', 'unfinityplus'),
            'param_name' => 'padding_bottom',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Padding Left', 'unfinityplus'),
            'param_name' => 'padding_left',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        /* Border radius */
        /* Padding */
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Border Radius Top', 'unfinityplus'),
            'param_name' => 'br_top',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Border Radius Right', 'unfinityplus'),
            'param_name' => 'br_right',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Border Radius Bottom', 'unfinityplus'),
            'param_name' => 'br_bottom',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Border Radius Left', 'unfinityplus'),
            'param_name' => 'br_left',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon Library', 'unfinityplus' ),
            'value' => array(
                esc_html__( 'Font Awesome', 'unfinityplus' ) => 'fontawesome',
                esc_html__( 'Material Design', 'unfinityplus' ) => 'material_design',
                esc_html__( 'Flaticon', 'unfinityplus' ) => 'flaticon',
            ),
            'param_name' => 'icon_list',
            'description' => esc_html__( 'Select icon library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Material', 'unfinityplus' ),
            'param_name' => 'icon_material_design',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'material-design',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'material_design',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome', 'unfinityplus' ),
            'param_name' => 'icon_fontawesome',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'fontawesome',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),  
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Flaticon', 'unfinityplus' ),
            'param_name' => 'icon_flaticon',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'flaticon',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'flaticon',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Button Settings', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Button Settings', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_button extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>