<?php
    if(class_exists('WPCF7')) {
        $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

        $contact_forms = array();
        if ( $cf7 ) {
            foreach ( $cf7 as $cform ) {
                $contact_forms[ $cform->post_title ] = $cform->ID;
            }
        } else {
            $contact_forms[ esc_html__( 'No contact forms found', 'unfinityplus' ) ] = 0;
        }

        vc_map(array(
            'name' => 'Contact Form',
            'base' => 'cms_contact_form',
            'class'    => 'ct-icon-element',
            'description' => esc_html__( 'Contact Form 7', 'unfinityplus' ),
            'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
            'params' => array(
                 /* Template */
                array(
                    'type' => 'cms_template_img',
                    'param_name' => 'cms_template',
                    'shortcode' => 'cms_contact_form',
                    'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                    'admin_label' => true,
                    'group' => esc_html__('Template', 'unfinityplus'),
                    'std' => 'cms_contact_form.php'
                ),

                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Select Contact Form', 'unfinityplus' ),
                    'param_name' => 'id',
                    'value' => $contact_forms,
                    'save_always' => true,
                    'admin_label' => true,
                    'description' => __( 'Choose previously created contact form from the drop down list.', 'unfinityplus' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Form Style', 'unfinityplus'),
                    'param_name' => 'form_style',
                    'value' => array(
                        'Style 1' => 'form-style1',
                        'Style 2' => 'form-style2',
                        'Style 3' => 'form-style3',
                        'Style 4 (Outline Primary)' => 'form-style4',
                        'Style 5 (Outline White)' => 'form-style5',
                        'Style 6 (Outline Gray)' => 'form-style6',
                        'Style 7 (Outline Bottom)' => 'form-style7',
                        'Style 8 (Outline Secondary)' => 'form-style8',
                    ),
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form.php',
                        )
                    ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Form Style', 'unfinityplus'),
                    'param_name' => 'form2_style',
                    'value' => array(
                        'Style 1' => 'form-style1',
                        'Style 2' => 'form-style2',
                    ),
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout1.php',
                        )
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Element Title', 'unfinityplus'),
                    'param_name' => 'el_title',
                    'dependency' => array(
                        'element'=>'form2_style',
                        'value'=>array(
                            'form-style1',
                        )
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Element Title', 'unfinityplus'),
                    'param_name' => 'el2_title',
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout2.php',
                            'cms_contact_form--layout3.php',
                        )
                    ),
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'contact_image',
                    'value' => '',
                    'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout3.php',
                        )
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Element Sub Title', 'unfinityplus'),
                    'param_name' => 'el_sub_title',
                    'dependency' => array(
                        'element'=>'form2_style',
                        'value'=>array(
                            'form-style1',
                        )
                    ),
                ),
                array(
                    'type' => 'textarea',
                    'heading' => esc_html__('Element Description', 'unfinityplus'),
                    'param_name' => 'el_description',
                    'dependency' => array(
                        'element'=>'form2_style',
                        'value'=>array(
                            'form-style1',
                        )
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Address', 'unfinityplus'),
                    'param_name' => 'el_address',
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout1.php',
                        )
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Phone', 'unfinityplus'),
                    'param_name' => 'el_phone',
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout1.php',
                        )
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Email', 'unfinityplus'),
                    'param_name' => 'el_email',
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout1.php',
                        )
                    ),
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Map Background Image', 'unfinityplus' ),
                    'param_name' => 'map_image',
                    'value' => '',
                    'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout1.php',
                        )
                    ),
                ),
                array(
                    'type' => 'textarea_safe',
                    'heading' => esc_html__('Map Embed Iframe', 'unfinityplus'),
                    'param_name' => 'el_map_iframe',
                    'value' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2481.253243068249!2d-0.07899078384312165!3d51.545255179641245!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x48761c91f36ba6cb%3A0xa3353c086b61a5e4!2s14+Tottenham+Rd%2C+London+N1+4EP%2C+UK!5e0!3m2!1sen!2s!4v1533518661165" width="600" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>',
                    'dependency' => array(
                        'element'=>'cms_template',
                        'value'=>array(
                            'cms_contact_form--layout1.php',
                        )
                    ),
                    'description' => sprintf( esc_html__( 'Visit %s to create your map (Step by step: 1) Find location 2) Click the cog symbol in the lower right corner and select "Share or embed map" 3) On modal window select "Embed map" 4) Copy iframe code and paste it).', 'unfinityplus' ), '<a href="https://www.google.com/maps" target="_blank">' . esc_html__( 'Google maps', 'unfinityplus' ) . '</a>' ),
                ),
                /* Extra */
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
                    'param_name' => 'el_class',
                    'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
                    'group'      => esc_html__('Extra', 'unfinityplus'),
                ),
                array(
                    'type' => 'animation_style',
                    'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
                    'param_name' => 'animation',
                    'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
                    'admin_label' => false,
                    'weight' => 0,
                    'group' => esc_html__('Extra', 'unfinityplus'),
                ),
            )
        ));

        class WPBakeryShortCode_cms_contact_form extends CmsShortCode
        {

            protected function content($atts, $content = null)
            {
                return parent::content($atts, $content);
            }
        }
    }
?>