<?php
	if(class_exists('CmsShortCode')){
		vc_map(
			array(
				'name' => esc_html__('Countdown', 'unfinityplus'),
			    'base' => 'cms_countdown',
			    'class'    => 'ct-icon-element',
            	'description' => esc_html__( 'Countdown Displayed', 'unfinityplus' ),
			    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
			    'params' => array(
			    	array(
			            'type' => 'textarea',
			            'heading' => esc_html__( 'Element Title', 'unfinityplus' ),
			            'param_name' => 'el_title',
			            'value' => '',
			            'admin_label' => true,
			        ),
			        array(
			            'type' => 'textfield',
			            'heading' => esc_html__('Date count down', 'unfinityplus'),
			            'param_name' => 'date_count_down',
			            'value' => '',
			            'description' => esc_html__('Set date count down (Date format: yy/mm/dd)', 'unfinityplus'),
			        ),
			        array(
			            'type' => 'textfield',
			            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
			            'param_name' => 'el_class',
			            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
			        	'group' => esc_html__('Extra', 'unfinityplus'),
			        ),
			        array(
			            'type' => 'animation_style',
			            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
			            'param_name' => 'animation',
			            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
			            'admin_label' => false,
			            'weight' => 0,
			            'group' => esc_html__('Extra', 'unfinityplus'),
			        )
			    )
			)
		);
		class WPBakeryShortCode_cms_countdown extends CmsShortCode{
			protected function content($atts, $content = null){
				wp_enqueue_script('ct-countdown-config', get_template_directory_uri() . '/assets/js/ct-countdown.js', array( 'jquery' ), 'all', true);
				return parent::content($atts, $content);
			}
		}
	}
?>