<?php
vc_map(array(
    'name' => 'Fancy Box',
    'base' => 'cms_fancybox',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Fancy Box Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_fancybox',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'std' => 'cms_fancybox.php',
            'group' => esc_html__('Template', 'unfinityplus'),
        ),

        /* Title */
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Title', 'unfinityplus'),
            'param_name' => 'title',
            'description' => 'Enter title.',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Text Color', 'unfinityplus'),
            'param_name' => 'title_color',
            'value' => '',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Font Size', 'unfinityplus'),
            'param_name' => 'title_font_size',
            'description' => 'Enter number.',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Line Height', 'unfinityplus'),
            'param_name' => 'title_line_height',
            'description' => 'Enter number.',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'vc_link',
            'class' => '',
            'heading' => esc_html__('Link', 'unfinityplus'),
            'param_name' => 'title_link',
            'value' => '',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                )
            ),
        ),

        /* Description */
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Description', 'unfinityplus'),
            'param_name' => 'description',
            'description' => 'Enter description.',
            'group' => esc_html__('Description', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout5.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Text Color', 'unfinityplus'),
            'param_name' => 'description_color',
            'value' => '',
            'group' => esc_html__('Description', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),

        /* Icon */
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Type', 'unfinityplus'),
            'param_name' => 'icon_type',
            'value' => array(
                'Icon' => 'icon',
                'Image' => 'image',
            ),
            'group' => esc_html__('Icon', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                    'cms_fancybox--layout2.php',
                    'cms_fancybox--layout3.php',
                    'cms_fancybox--layout4.php',
                    'cms_fancybox--layout5.php',
                )
            ),
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Icon Image', 'unfinityplus' ),
            'param_name' => 'icon_image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
            'dependency' => array(
                'element'=>'icon_type',
                'value'=>array(
                    'image',
                )
            ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon Library', 'unfinityplus' ),
            'value' => array(
                esc_html__( 'Font Awesome', 'unfinityplus' ) => 'fontawesome',
                esc_html__( 'Material Design', 'unfinityplus' ) => 'material_design',
                esc_html__( 'Flaticon', 'unfinityplus' ) => 'flaticon',
                esc_html__( 'ET Line', 'unfinityplus' ) => 'etline',
            ),
            'param_name' => 'icon_list',
            'description' => esc_html__( 'Select icon library.', 'unfinityplus' ),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'icon',
            ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Material', 'unfinityplus' ),
            'param_name' => 'icon_material_design',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'material-design',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'material_design',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome', 'unfinityplus' ),
            'param_name' => 'icon_fontawesome',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'fontawesome',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),  
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Flaticon', 'unfinityplus' ),
            'param_name' => 'icon_flaticon',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'flaticon',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'flaticon',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon ET Line', 'unfinityplus' ),
            'param_name' => 'icon_etline',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'etline',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'etline',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Icon Color', 'unfinityplus'),
            'param_name' => 'icon_color',
            'value' => '',
            'group' => esc_html__('Icon', 'unfinityplus'),
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'icon',
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Icon Font Size', 'unfinityplus'),
            'param_name' => 'icon_font_size',
            'group' => esc_html__('Icon', 'unfinityplus'),
            'description' => 'Enter number.',
            'dependency' => array(
                'element' => 'icon_type',
                'value' => 'icon',
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Style', 'unfinityplus'),
            'param_name' => 'icon_style_default',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
            ),
            'group' => esc_html__('Icon', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox.php',
                )
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Style', 'unfinityplus'),
            'param_name' => 'icon_style',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
                'Style 3' => 'style3',
                'Style 4' => 'style4',
            ),
            'group' => esc_html__('Icon', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout2.php',
                )
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon Style', 'unfinityplus'),
            'param_name' => 'icon_style_l4',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
            ),
            'group' => esc_html__('Icon', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout4.php',
                )
            ),
        ),

        /* Button */
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Text', 'unfinityplus'),
            'param_name' => 'btn_text',
            'group' => esc_html__('Button', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'vc_link',
            'class' => '',
            'heading' => esc_html__('Link', 'unfinityplus'),
            'param_name' => 'btn_link',
            'value' => '',
            'group' => esc_html__('Button', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout1.php',
                    'cms_fancybox--layout6.php',
                )
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Background Color', 'unfinityplus'),
            'param_name' => 'btn_bg_color',
            'value' => '',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout1.php',
                )
            ),
            'group' => esc_html__('Button', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'unfinityplus'),
            'param_name' => 'btn_text_color',
            'value' => '',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout1.php',
                )
            ),
            'group' => esc_html__('Button', 'unfinityplus'),
        ),

        /* Layout 2 */
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Box Image', 'unfinityplus' ),
            'param_name' => 'box_image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout1.php',
                )
            ),
            'group' => esc_html__('Template', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Box Color', 'unfinityplus'),
            'param_name' => 'box_color',
            'value' => '',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout1.php',
                )
            ),
            'group' => esc_html__('Template', 'unfinityplus'),
        ),

        /* Layout 6 */
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'unfinityplus' ),
            'param_name' => 'l6_image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox--layout6.php',
                )
            ),
            'group' => esc_html__('Image', 'unfinityplus'),
        ),

        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_fancybox extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>