<?php
$args = array(
    'name' => 'Fancy Box Carousel',
    'base' => 'cms_fancybox_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Deal Today Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_fancybox_carousel',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'unfinityplus'),
            'std' => 'cms_fancybox_carousel.php'
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Template', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Template', 'unfinityplus'),
        ),
        
        /* Layout 1 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'unfinityplus' ),
            'param_name' => 'content_list',
            'description' => esc_html__( 'Enter values for fancybox item', 'unfinityplus' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox_carousel.php',
                    'cms_fancybox_carousel--layout3.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'fancybox_image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'fancybox_title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Sub Title', 'unfinityplus'),
                    'param_name' => 'fancybox_sub_title',
                    'value' => '',
                ),
                array(
                    'type' => 'textarea',
                    'heading' =>esc_html__('Content', 'unfinityplus'),
                    'param_name' => 'fancybox_content',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Button Text', 'unfinityplus' ),
                    'param_name' => 'button_text',
                    'value' => '',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'vc_link',
                    'class' => '',
                    'heading' => esc_html__('Button Link', 'unfinityplus'),
                    'param_name' => 'button_link',
                    'value' => '',
                ),
            ),
        ),

        /* Layout 2 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'unfinityplus' ),
            'param_name' => 'content_list2',
            'description' => esc_html__( 'Enter values for fancybox item', 'unfinityplus' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_fancybox_carousel--layout2.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'fancybox_image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'fancybox_title',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Date', 'unfinityplus'),
                    'param_name' => 'fancybox_date',
                    'value' => '',
                ),
                array(
                    'type' => 'textarea',
                    'heading' =>esc_html__('Content', 'unfinityplus'),
                    'param_name' => 'fancybox_content',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Button Text', 'unfinityplus' ),
                    'param_name' => 'button_text',
                    'value' => '',
                    'admin_label' => true,
                ),
                array(
                    'type' => 'vc_link',
                    'class' => '',
                    'heading' => esc_html__('Button Link', 'unfinityplus'),
                    'param_name' => 'button_link',
                    'value' => '',
                ),
            ),
        ),

    ));

$args = unfinityplus_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_cms_fancybox_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>