<?php
vc_map(array(
    'name' => 'Google Map',
    'base' => 'cms_googlemap',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Google Map Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__('API Key', 'unfinityplus'),
            'param_name' => 'api',
            'value' => '',
            'description' => esc_html__('Enter you api key of map, get key from (https://console.developers.google.com)', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Address', 'unfinityplus'),
            'param_name' => 'address',
            'value' => 'New York, United States',
            'description' => esc_html__('Enter address of Map', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Coordinate', 'unfinityplus'),
            'param_name' => 'coordinate',
            'value' => '',
            'description' => esc_html__('Enter coordinate of Map, format input (latitude, longitude)', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Click Show Info window', 'unfinityplus'),
            'param_name' => 'infoclick',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Click a marker and show info window (Default Show).', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Marker Coordinate', 'unfinityplus'),
            'param_name' => 'markercoordinate',
            'value' => '',
            'description' => esc_html__('Enter marker coordinate of Map, format input (latitude, longitude)', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Marker Title', 'unfinityplus'),
            'param_name' => 'markertitle',
            'value' => '',
            'description' => esc_html__('Enter Title Info windows for marker', 'unfinityplus')
        ),
        array(
            'type' => 'textarea',
            'heading' => esc_html__('Marker Description', 'unfinityplus'),
            'param_name' => 'markerdesc',
            'value' => '',
            'description' => esc_html__('Enter Description Info windows for marker', 'unfinityplus')
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__('Marker Icon', 'unfinityplus'),
            'param_name' => 'markericon',
            'value' => '',
            'description' => esc_html__('Select image icon for marker', 'unfinityplus')
        ),
        array(
            'type' => 'textarea_raw_html',
            'heading' => esc_html__('Marker List', 'unfinityplus'),
            'param_name' => 'markerlist',
            'value' => '',
            'description' => esc_html__('[{"coordinate":"41.058846,-73.539423","icon":"","title":"title demo 1","desc":"desc demo 1"},{"coordinate":"40.975699,-73.717636","icon":"","title":"title demo 2","desc":"desc demo 2"},{"coordinate":"41.082606,-73.469718","icon":"","title":"title demo 3","desc":"desc demo 3"}]', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Info Window Max Width', 'unfinityplus'),
            'param_name' => 'infowidth',
            'value' => '200',
            'description' => esc_html__('Set max width for info window', 'unfinityplus')
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Map Type', 'unfinityplus'),
            'param_name' => 'type',
            'value' => array(
                'ROADMAP' => 'ROADMAP',
                'HYBRID' => 'HYBRID',
                'SATELLITE' => 'SATELLITE',
                'TERRAIN' => 'TERRAIN'
            ),
            'description' => esc_html__('Select the map type.', 'unfinityplus')
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Style Template', 'unfinityplus'),
            'param_name' => 'style',
            'value' => array(
                'Default' => '',
                'Custom' => 'custom',
                'Light Monochrome' => 'light-monochrome',
                'Blue water' => 'blue-water',
                'Midnight Commander' => 'midnight-commander',
                'Paper' => 'paper',
                'Red Hues' => 'red-hues',
                'Hot Pink' => 'hot-pink'
            ),
            'description' => 'Select your heading size for title.'
        ),
        array(
            'type' => 'textarea_raw_html',
            'heading' => esc_html__('Custom Template', 'unfinityplus'),
            'param_name' => 'content',
            'value' => '',
            'description' => esc_html__('Get template from http://snazzymaps.com', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Zoom', 'unfinityplus'),
            'param_name' => 'zoom',
            'value' => '13',
            'description' => esc_html__('zoom level of map, default is 13', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Width', 'unfinityplus'),
            'param_name' => 'width',
            'value' => 'auto',
            'description' => esc_html__('Width of map without pixel, default is auto', 'unfinityplus')
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Height', 'unfinityplus'),
            'param_name' => 'height',
            'value' => '350px',
            'description' => esc_html__('Height of map without pixel, default is 350px', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Scroll Wheel', 'unfinityplus'),
            'param_name' => 'scrollwheel',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('If false, disables scrollwheel zooming on the map. The scrollwheel is disable by default.', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Pan Control', 'unfinityplus'),
            'param_name' => 'pancontrol',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Show or hide Pan control.', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Zoom Control', 'unfinityplus'),
            'param_name' => 'zoomcontrol',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Show or hide Zoom Control.', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Scale Control', 'unfinityplus'),
            'param_name' => 'scalecontrol',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Show or hide Scale Control.', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Map Type Control', 'unfinityplus'),
            'param_name' => 'maptypecontrol',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Show or hide Map Type Control.', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Street View Control', 'unfinityplus'),
            'param_name' => 'streetviewcontrol',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Show or hide Street View Control.', 'unfinityplus')
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Over View Map Control', 'unfinityplus'),
            'param_name' => 'overviewmapcontrol',
            'value' => array(
                esc_html__('Yes, please', 'unfinityplus') => true
            ),
            'description' => esc_html__('Show or hide Over View Map Control.', 'unfinityplus')
        ),
    )
));

class WPBakeryShortCode_cms_googlemap extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>