<?php
vc_map(array(
    'name' => 'Heading',
    'base' => 'cms_heading',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Heading Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text Source', 'unfinityplus'),
            'param_name' => 'text_source',
            'value' => array(
                'Custom Text' => 'custom-text',
                'Post or Page Title' => 'post-page-title',
            ),
            'admin_label' => true,
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textarea',
            'heading' => esc_html__( 'Text', 'unfinityplus' ),
            'param_name' => 'text',
            'value' => '',
            'admin_label' => true,
            'dependency' => array(
                'element'=>'text_source',
                'value'=>array(
                    'custom-text',
                )
            ),
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Element tag', 'unfinityplus'),
            'param_name' => 'tag',
            'value' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'div' => 'div',
            ),
            'std' => 'h3',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text align large', 'unfinityplus'),
            'param_name' => 'align_lg',
            'value' => array(
                'left' => 'align-left',
                'right' => 'align-right',
                'center' => 'align-center',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text align medium', 'unfinityplus'),
            'param_name' => 'align_md',
            'value' => array(
                'left' => 'align-left-md',
                'right' => 'align-right-md',
                'center' => 'align-center-md',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text align small', 'unfinityplus'),
            'param_name' => 'align_sm',
            'value' => array(
                'left' => 'align-left-sm',
                'right' => 'align-right-sm',
                'center' => 'align-center-sm',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text align mini', 'unfinityplus'),
            'param_name' => 'align_xs',
            'value' => array(
                'left' => 'align-left-xs',
                'right' => 'align-right-xs',
                'center' => 'align-center-xs',
            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Margin top', 'unfinityplus'),
            'param_name' => 'margin_top',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Margin right', 'unfinityplus'),
            'param_name' => 'margin_right',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Margin bottom', 'unfinityplus'),
            'param_name' => 'margin_bottom',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Margin left', 'unfinityplus'),
            'param_name' => 'margin_left',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font size large', 'unfinityplus' ),
            'param_name' => 'font_size',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font size medium', 'unfinityplus' ),
            'param_name' => 'font_size_md',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font size small', 'unfinityplus' ),
            'param_name' => 'font_size_sm',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font size mini', 'unfinityplus' ),
            'param_name' => 'font_size_xs',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line height large', 'unfinityplus' ),
            'param_name' => 'line_height',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line height medium', 'unfinityplus' ),
            'param_name' => 'line_height_md',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line height small', 'unfinityplus' ),
            'param_name' => 'line_height_sm',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line height mini', 'unfinityplus' ),
            'param_name' => 'line_height_xs',
            'value' => '',
            'description' => 'Enter number.',
            'edit_field_class' => 'vc_col-sm-3 vc_column',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text Transform', 'unfinityplus'),
            'param_name' => 'text_transform',
            'value' => array(
                'None' => 'none',
                'Inherit' => 'inherit',
                'Uppercase' => 'uppercase',
                'Capitalize' => 'capitalize',
                'Lowercase' => 'lowercase',
            ),
            'std' => 'none',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text Decoration', 'unfinityplus'),
            'param_name' => 'text_decoration',
            'value' => array(
                'None' => 'none',
                'Underline' => 'underline',
            ),
            'std' => 'none',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Font Weight', 'unfinityplus'),
            'param_name' => 'font_weight',
            'value' => array(
                'Default' => '',
                'Bold' => '700',
                'SemiBold' => '600',
                'Medium' => '500',
                'Normal' => '400',
            ),
            'std' => 'none',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Letter Spacing', 'unfinityplus' ),
            'param_name' => 'letter_spacing',
            'value' => '',
            'description' => 'Enter ..px, ..em',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Divider', 'unfinityplus'),
            'param_name' => 'divider',
            'value' => array(
                'None' => 'none',
                'Divider 1' => 'divider1',
                'Divider 2' => 'divider2',
                'Divider 3' => 'divider3',
            ),
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Text Color', 'unfinityplus'),
            'param_name' => 'text_color',
            'value' => '',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Custom Google Fonts', 'unfinityplus'),
            'param_name' => 'custom_fonts',
            'value' => array(
                'No' => 'false',
                'Yes' => 'true',
            ),
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'google_fonts',
            'param_name' => 'google_fonts',
            'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__( 'Select font family.', 'unfinityplus' ),
                    'font_style_description' => esc_html__( 'Select font styling.', 'unfinityplus' ),
                ),
            ),
            'dependency' => array(
                'element'=>'custom_fonts',
                'value'=>array(
                    'true',
                )
            ),
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'vc_link',
            'heading' => esc_html__( 'Link for title', 'unfinityplus' ),
            'param_name' => 'title_link',
            'value' => '',
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Title Style', 'unfinityplus'),
            'param_name' => 'title_layout',
            'value' => array(
                'Style Default' => 'style-default',
                'Style Lawyer' => 'style-lawyer',
                'Style Industrial' => 'style-industrial',
            ),
            'group' => esc_html__('Title', 'unfinityplus'),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button', 'unfinityplus'),
            'param_name' => 'h_button',
            'value' => array(
                'No' => 'false',
                'Yes' => 'true',
            ),
            'group' => esc_html__('Title', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Text Button', 'unfinityplus' ),
            'param_name' => 'h_text',
            'value' => '',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'h_button',
                'value'=>array(
                    'true',
                )
            ),
        ),
        array(
            'type' => 'vc_link',
            'heading' => esc_html__( 'Link Button', 'unfinityplus' ),
            'param_name' => 'h_link',
            'value' => '',
            'group' => esc_html__('Title', 'unfinityplus'),
            'dependency' => array(
                'element'=>'h_button',
                'value'=>array(
                    'true',
                )
            ),
        ),
        /* Description */
        array(
            'type' => 'textarea',
            'heading' => esc_html__( 'Description', 'unfinityplus' ),
            'param_name' => 'description',
            'value' => '',
            'group'      => esc_html__('Description', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font Size', 'unfinityplus' ),
            'param_name' => 'description_font_size',
            'value' => '',
            'description' => 'Enter number.',
            'group'      => esc_html__('Description', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line Height', 'unfinityplus' ),
            'param_name' => 'description_line_height',
            'value' => '',
            'description' => 'Enter number.',
            'group'      => esc_html__('Description', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'unfinityplus'),
            'param_name' => 'description_color',
            'value' => '',
            'group'      => esc_html__('Description', 'unfinityplus'),
        ),
        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'      => esc_html__('Extra', 'unfinityplus'),
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_heading extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('ct-heading');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>