<?php
vc_map(array(
    "name" => 'Lists',
    "base" => "cms_list",
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Lists Displayed', 'unfinityplus' ),
    "category" => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    "params" => array(

        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Lists', 'unfinityplus' ),
            'param_name' => 'cms_list',
            'description' => esc_html__( 'Enter values for list item', 'unfinityplus' ),
            'value' => '',
            'params' => array(
                array(
                    "type" => "textfield",
                    "heading" =>esc_html__("List item", 'unfinityplus'),
                    "param_name" => "cms_list_item",
                    'admin_label' => true,
                ),
            ),
        ),

        array(
            "type" => "textfield",
            "heading" =>esc_html__("Font Size", 'unfinityplus'),
            "param_name" => "cms_list_fontsize",
            'value' => '',
            "description" => "Enter number."
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__("Line Height", 'unfinityplus'),
            "param_name" => "cms_list_lineheight",
            'value' => '',
            "description" => "Enter number."
        ),
        array(
            "type" => "colorpicker",
            "heading" =>esc_html__("Color", 'unfinityplus'),
            "param_name" => "cms_list_color",
            'value' => '',
        ),

        /* Icon */
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon Library', 'unfinityplus' ),
            'value' => array(
                esc_html__( 'Font Awesome', 'unfinityplus' ) => 'fontawesome',
                esc_html__( 'Material Design', 'unfinityplus' ) => 'material_design',
                esc_html__( 'Flaticon', 'unfinityplus' ) => 'flaticon',
            ),
            'param_name' => 'icon_list',
            'description' => esc_html__( 'Select icon library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon Material', 'unfinityplus' ),
            'param_name' => 'icon_material_design',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'material-design',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'material_design',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Icon FontAwesome', 'unfinityplus' ),
            'param_name' => 'icon_fontawesome',
            'value' => '',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'fontawesome',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),  
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__( 'Flaticon', 'unfinityplus' ),
            'param_name' => 'icon_flaticon',
            'settings' => array(
                'emptyIcon' => true,
                'type' => 'flaticon',
                'iconsPerPage' => 200,
            ),
            'dependency' => array(
                'element' => 'icon_list',
                'value' => 'flaticon',
            ),
            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Icon Color', 'unfinityplus'),
            'param_name' => 'icon_color',
            'value' => '',
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__("Font Size", 'unfinityplus'),
            "param_name" => "icon_fontsize",
            'value' => '',
            "description" => "Enter number.",
            'group' => esc_html__('Icon', 'unfinityplus'),
        ),
        /* Extra */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
    )
));

class WPBakeryShortCode_cms_list extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}
?>