<?php
vc_map(
    array(
        'name'     => esc_html__('Menu Grid', 'unfinityplus'),
        'base'     => 'cms_menu_grid',
        'class'    => 'ct-icon-element',
        'description' => 'Menu Restaurant Displayed',
        'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
        'params'   => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_menu_grid',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_menu_grid.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Content', 'unfinityplus' ),
                'param_name' => 'content_list',
                'description' => esc_html__( 'Enter values for menu item', 'unfinityplus' ),
                'value' => '',
                'group' => esc_html__('Source Settings', 'unfinityplus'),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_menu_grid.php',
                    )
                ),
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'unfinityplus' ),
                        'param_name' => 'image',
                        'value' => '',
                        'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Title', 'unfinityplus'),
                        'param_name' => 'title',
                        'admin_label' => true,
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' => esc_html__( 'Description', 'unfinityplus' ),
                        'param_name' => 'desc',
                        'value' => '',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Price', 'unfinityplus'),
                        'param_name' => 'menu_price',
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Category', 'unfinityplus'),
                        'param_name' => 'category',
                        'admin_label' => true,
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                        'description' => 'Enter category. Enter multiple categories (Example: "Category 1, Category 2, Category 3")'
                    ),
                ),
            ),
            
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__('Filter', 'unfinityplus'),
                'param_name' => 'filter',
                'value'      => array(
                    'Enable'  => 'true',
                    'Disable' => 'false'
                ),
                'group'      => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Default Title', 'unfinityplus'),
                'param_name' => 'filter_default_title',
                'value'      => 'All',
                'group'      => esc_html__('Grid Settings', 'unfinityplus'),
                'description' => esc_html__('Enter default title for filter option display, empty: All', 'unfinityplus'),
                'dependency' => array(
                    'element' => 'filter',
                    'value'   => 'true'
                ),
            ),

            array(
                'type'       => 'textfield',
                'heading'    => esc_html__('Item Gap', 'unfinityplus'),
                'param_name' => 'gap',
                'value'      => '30',
                'group'      => esc_html__('Grid Settings', 'unfinityplus'),
                'description' => esc_html__('Select gap between grid elements. Enter number only', 'unfinityplus'),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns XS Devices', 'unfinityplus'),
                'param_name'       => 'col_xs',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 1,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns SM Devices', 'unfinityplus'),
                'param_name'       => 'col_sm',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 2,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns MD Devices', 'unfinityplus'),
                'param_name'       => 'col_md',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 3,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns LG Devices', 'unfinityplus'),
                'param_name'       => 'col_lg',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 4,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
        )
    )
);

class WPBakeryShortCode_cms_menu_grid extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('cms-menu-grid');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>