<?php
/**
 * Newsletter form for VC
 * Require Newsletter plugin to be installed
 *
 * @package Autosmart
 * @since   Autosmart 1.0
 */

if(class_exists('Newsletter')) {
    $forms = array_filter( (array) get_option( 'newsletter_forms', array() ) );

    $forms_list = array(
        esc_html__( 'Default Form', 'unfinityplus' ) => 'default'
    );

    if ( $forms )
    {
        $index = 1;
        foreach ( $forms as $key => $form )
        {
            $forms_list[ sprintf( esc_html__( 'Form %s', 'unfinityplus' ), $index ) ] = $key;
            $index ++;
        }
    }

    vc_map(array(
        "name" => 'Newsletter',
        "base" => "cms_newsletter",
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Newsletter Form', 'unfinityplus' ),
        "category" => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
        "params" => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_newsletter',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_newsletter.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
                'type'        => 'dropdown',
                'heading'     => esc_html__( 'Newsletter Form', 'unfinityplus' ),
                'description' => esc_html__( 'Pick default or custom forms from Newsletter Plugin.', 'unfinityplus' ),
                'value'       => $forms_list,
                'admin_label' => true,
                'param_name'  => 'form'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Form Style', 'unfinityplus'),
                'param_name' => 'form_style',
                'value' => array(
                    'Style 1' => 'form-style1',
                    'Style 2' => 'form-style2',
                    'Style 3' => 'form-style3',
                    'Style 4' => 'form-style4',
                    'Style 5' => 'form-style5',
                ),
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_newsletter.php',
                    )
                ),
            ),
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Title', 'unfinityplus' ),
                'param_name' => 'el_title',
                'value' => '',
                'admin_label' => true,
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_newsletter--layout1.php',
                    )
                ),
            ),
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Description', 'unfinityplus' ),
                'param_name' => 'el_desc',
                'value' => '',
                'dependency' => array(
                    'element'=>'cms_template',
                    'value'=>array(
                        'cms_newsletter--layout1.php',
                    )
                ),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__( "Extra class name", 'unfinityplus' ),
                "param_name" => "el_class",
                "description" => esc_html__( "Style particular content element differently - add a class name and refer to it in Custom CSS.", 'unfinityplus' ),
                'group' => esc_html__('Extra', 'unfinityplus'),
            ),
            array(
                'type' => 'animation_style',
                'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
                'param_name' => 'animation',
                'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
                'admin_label' => false,
                'weight' => 0,
                'group' => esc_html__('Extra', 'unfinityplus'),
            ),
        )
    ));

    class WPBakeryShortCode_cms_newsletter extends CmsShortCode
    {

        protected function content($atts, $content = null)
        {
            return parent::content($atts, $content);
        }
    }
} ?>