<?php
vc_map(array(
    'name' => 'Row Overlay',
    'base' => 'cms_overlay',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Overlay Color Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        
        array(    
            'type' => 'dropdown',
            'heading' => esc_html__('Type', 'unfinityplus'),
            'param_name' => 'color',
            'value' => array(  
                'Regular' => 'regular',         
                'Gradient' => 'gradient',         
            ),
        ),
        array(    
            'type' => 'dropdown',
            'heading' => esc_html__('Flip', 'unfinityplus'),
            'param_name' => 'flip',
            'value' => array(  
                'Horizontal' => 'horizontal',         
                'Vertical' => 'vertical',         
            ),
            'dependency' => array(
                'element'=>'color',
                'value'=>array(
                    'gradient',
                )
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'unfinityplus'),
            'param_name' => 'regular_color',
            'value' => '',
            'dependency' => array(
                'element'=>'color',
                'value'=>array(
                    'regular',
                )
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color 1', 'unfinityplus'),
            'param_name' => 'gradient_color1',
            'value' => '',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'dependency' => array(
                'element'=>'color',
                'value'=>array(
                    'gradient',
                )
            ),
            'description' => 'Default color gradient in theme option.',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color 2', 'unfinityplus'),
            'param_name' => 'gradient_color2',
            'value' => '',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'dependency' => array(
                'element'=>'color',
                'value'=>array(
                    'gradient',
                )
            ),
            'description' => 'Default color gradient in theme option.',
        ),
        array(    
            'type' => 'dropdown',
            'heading' => esc_html__('Position', 'unfinityplus'),
            'param_name' => 'position',
            'value' => array(  
                'in Row' => 'in-row',         
                'in Column' => 'in-column',         
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Text', 'unfinityplus'),
            'param_name' => 'text',
            'group' => esc_html__('Text', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Text Position Top', 'unfinityplus' ),
            'param_name' => 'text_top',
            'value' => '',
            'description' => 'Enter: ..px, ..%, ..em',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'group' => esc_html__('Text', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Text Position Left', 'unfinityplus' ),
            'param_name' => 'text_left',
            'value' => '',
            'description' => 'Enter: ..px, ..%, ..em',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            'group' => esc_html__('Text', 'unfinityplus'),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Color', 'unfinityplus'),
            'param_name' => 'text_color',
            'value' => '',
            'group' => esc_html__('Text', 'unfinityplus'),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font Size', 'unfinityplus' ),
            'param_name' => 'text_font_size',
            'value' => '',
            'description' => 'Enter number.',
            'group' => esc_html__('Text', 'unfinityplus'),
        ),
        
    )
));

class WPBakeryShortCode_cms_overlay extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>