<?php
vc_map(array(
    'name' => 'Phone Info',
    'base' => 'cms_phone_info',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Phone Info Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Layout', 'unfinityplus'),
            'param_name' => 'layout',
            'value' => array(
                'Layout 1' => 'layout1',
                'Layout 2' => 'layout2',
            ),
        ),
        /* Layout 2 */
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Phone', 'unfinityplus' ),
            'param_name' => 'phone',
            'value' => '',
            'admin_label' => true,
            'dependency' => array(
                'element'=>'layout',
                'value'=>array(
                    'layout2',
                )
            ),
        ),
        array(
            'type' => 'textarea',
            'heading' => esc_html__( 'Title', 'unfinityplus' ),
            'param_name' => 'title',
            'value' => '',
            'admin_label' => true,
            'dependency' => array(
                'element'=>'layout',
                'value'=>array(
                    'layout1',
                    'layout2',
                )
            ),
        ),
        array(
            'type' => 'textarea',
            'heading' => esc_html__( 'Sub Title', 'unfinityplus' ),
            'param_name' => 'subtitle',
            'value' => '',
            'dependency' => array(
                'element'=>'layout',
                'value'=>array(
                    'layout1',
                )
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Button Text', 'unfinityplus'),
            'param_name' => 'btn_text',
            'dependency' => array(
                'element'=>'layout',
                'value'=>array(
                    'layout1',
                )
            ),
        ),
        array(
            'type' => 'vc_link',
            'class' => '',
            'heading' => esc_html__('Button Link', 'unfinityplus'),
            'param_name' => 'btn_link',
            'value' => '',
            'dependency' => array(
                'element'=>'layout',
                'value'=>array(
                    'layout1',
                )
            ),
        ),
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'unfinityplus' ),
            'param_name' => 'image',
            'value' => '',
            'description' => esc_html__( 'Select icon image from media library.', 'unfinityplus' ),
            'dependency' => array(
                'element'=>'layout',
                'value'=>array(
                    'layout1',
                )
            ),
        ),
    )
));

class WPBakeryShortCode_cms_phone_info extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>