<?php
vc_map(
	array(
		'name' => esc_html__('Progress Bar', 'unfinityplus'),
	    'base' => 'cms_progressbar',
	    'class'    => 'ct-icon-element',
	    'description' => esc_html__( 'Progress Bar Displayed', 'unfinityplus' ),
	    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
	    'params' => array(
	    	array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_progressbar',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_progressbar.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
            'type' => 'dropdown',
	            'heading' => esc_html__('Style', 'unfinityplus'),
	            'param_name' => 'style',
	            'value' => array(
	                'Style 1' => 'style1',
	                'Style 2' => 'style2',
	            ),
	            'group' => esc_html__('Template', 'unfinityplus'),
	            'dependency' => array(
	                'element'=>'cms_template',
	                'value'=>array(
	                    'cms_progressbar.php',
	                )
	            ),
	        ),
            array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Extra Class', 'unfinityplus'),
	            'param_name' => 'el_class',
	            'value' => '',
	            'group' => esc_html__('Template', 'unfinityplus')
	        ),
	        array(
	            'type' => 'param_group',
	            'heading' => esc_html__( 'Progress Bar Lists', 'unfinityplus' ),
	            'param_name' => 'cms_progressbar_list',
	            'value' => '',
	            'params' => array(
	                array(
			            'type' => 'textfield',
			            'heading' => esc_html__('Item Title', 'unfinityplus'),
			            'param_name' => 'item_title',
			            'value' => '',
			            'group' => esc_html__('Progress Bar Settings', 'unfinityplus'),
			            'admin_label' => true,
			        ),
					array(
						'type' => 'textfield',
						'class' => '',
						'value' => '',
						'heading' => esc_html__( 'Value', 'unfinityplus' ),
						'param_name' => 'value',
						'description' => 'Enter number only 1 to 100',
						'group' => esc_html__('Progress Bar Settings', 'unfinityplus'),
						'admin_label' => true,
					),
	            ),
	        ),
	    )
	)
);
class WPBakeryShortCode_cms_progressbar extends CmsShortCode{
	protected function content($atts, $content = null){
		/* CSS */
	    wp_enqueue_style('progressbar', get_template_directory_uri() . '/assets/css/progressbar.min.css', array(), '0.7.1');
	    /* JS */
	    wp_enqueue_script('progressbar', get_template_directory_uri() . '/assets/js/progressbar.min.js', array( 'jquery' ), '0.7.1', true);
	    wp_enqueue_script('ct-progressbar', get_template_directory_uri() . '/assets/js/progressbar.ct.js', array( 'jquery' ), 'all', true);
	    wp_enqueue_script('waypoints');
		return parent::content($atts, $content);
	}
}

?>