<?php
vc_map(
    array(
        'name'     => esc_html__('Room Grid', 'unfinityplus'),
        'base'     => 'cms_room_grid',
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Room Grid Displayed', 'unfinityplus' ),
        'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
        'params'   => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_room_grid',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_room_grid.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Content', 'unfinityplus' ),
                'param_name' => 'content_list',
                'description' => esc_html__( 'Enter values for room item', 'unfinityplus' ),
                'value' => '',
                'group' => esc_html__('Source Settings', 'unfinityplus'),
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'unfinityplus' ),
                        'param_name' => 'image',
                        'value' => '',
                        'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Image size', 'unfinityplus' ),
                        'param_name' => 'img_size',
                        'value' => '',
                        'description' => esc_html__( "Enter image size (Example: 'thumbnail', 'medium', 'large', 'full' or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).", 'unfinityplus' ),
                        'group'      => esc_html__('Source Settings', 'unfinityplus')
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Title', 'unfinityplus'),
                        'param_name' => 'title',
                        'admin_label' => true,
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Price', 'unfinityplus'),
                        'param_name' => 'price',
                        'admin_label' => true,
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' =>esc_html__('Description', 'unfinityplus'),
                        'param_name' => 'desc',
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Button Text', 'unfinityplus' ),
                        'param_name' => 'button_text',
                        'value' => '',
                        'admin_label' => true,
                    ),
                    array(
                        'type' => 'vc_link',
                        'class' => '',
                        'heading' => esc_html__('Button Link', 'unfinityplus'),
                        'param_name' => 'button_link',
                        'value' => '',
                    ),
                    array(
                        'type' => 'param_group',
                        'heading' => esc_html__( 'Room Info', 'unfinityplus' ),
                        'param_name' => 'room_info',
                        'value' => '',
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                        'params' => array(
                            array(
                                'type' => 'iconpicker',
                                'heading' => esc_html__( 'Icon', 'unfinityplus' ),
                                'param_name' => 'info_icon',
                                'value' => '',
                                'settings' => array(
                                    'emptyIcon' => true,
                                    'type' => 'fontawesome',
                                    'iconsPerPage' => 200,
                                ),
                                'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
                                'admin_label' => true,
                            ),
                            array(
                                'type' => 'textfield',
                                'heading' =>esc_html__('Text', 'unfinityplus'),
                                'param_name' => 'info_text',
                                'admin_label' => true,
                            ),
                        ),
                    ),
                ),
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns XS Devices', 'unfinityplus'),
                'param_name'       => 'col_xs',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 1,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns SM Devices', 'unfinityplus'),
                'param_name'       => 'col_sm',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 2,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns MD Devices', 'unfinityplus'),
                'param_name'       => 'col_md',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 3,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type'             => 'dropdown',
                'heading'          => esc_html__('Columns LG Devices', 'unfinityplus'),
                'param_name'       => 'col_lg',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'value'            => array(1, 2, 3, 4, 6, 12),
                'std'              => 4,
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
        )
    )
);

class WPBakeryShortCode_cms_room_grid extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('cms-room-grid');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>