<?php
$args = array(
    'name' => 'Team Carousel',
    'base' => 'cms_team_carousel',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Team Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_team_carousel',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'unfinityplus'),
            'std' => 'cms_team_carousel.php'
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Template', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Template', 'unfinityplus'),
        ),
        
        /* Layout 1 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'unfinityplus' ),
            'param_name' => 'content_list',
            'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_team_carousel.php',
                    'cms_team_carousel--layout1.php',
                    'cms_team_carousel--layout2.php',
                    'cms_team_carousel--layout3.php',
                    'cms_team_carousel--layout6.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'unfinityplus'),
                    'param_name' => 'position',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Social', 'unfinityplus' ),
                    'param_name' => 'social',
                    'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
                    'value' => '',
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                    'params' => array(
                        array(
                            'type' => 'iconpicker',
                            'heading' => esc_html__( 'Icon', 'unfinityplus' ),
                            'param_name' => 'icon',
                            'value' => '',
                            'settings' => array(
                                'emptyIcon' => true,
                                'type' => 'fontawesome',
                                'iconsPerPage' => 200,
                            ),
                            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
                            'admin_label' => true,
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' =>esc_html__('Link', 'unfinityplus'),
                            'param_name' => 'social_link',
                            'admin_label' => true,
                        ),
                    ),
                ),
            ),
        ),

        /* Layout 4 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'unfinityplus' ),
            'param_name' => 'content_list_l4',
            'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_team_carousel--layout4.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'unfinityplus'),
                    'param_name' => 'position',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Phone', 'unfinityplus'),
                    'param_name' => 'phone',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textarea',
                    'heading' =>esc_html__('Description', 'unfinityplus'),
                    'param_name' => 'desc',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Social', 'unfinityplus' ),
                    'param_name' => 'social',
                    'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
                    'value' => '',
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                    'params' => array(
                        array(
                            'type' => 'iconpicker',
                            'heading' => esc_html__( 'Icon', 'unfinityplus' ),
                            'param_name' => 'icon',
                            'value' => '',
                            'settings' => array(
                                'emptyIcon' => true,
                                'type' => 'fontawesome',
                                'iconsPerPage' => 200,
                            ),
                            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
                            'admin_label' => true,
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' =>esc_html__('Link', 'unfinityplus'),
                            'param_name' => 'social_link',
                            'admin_label' => true,
                        ),
                    ),
                ),
            ),
        ),

        /* Layout 5 */
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Content', 'unfinityplus' ),
            'param_name' => 'content_list_l5',
            'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_team_carousel--layout5.php',
                )
            ),
            'params' => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Image', 'unfinityplus' ),
                    'param_name' => 'image',
                    'value' => '',
                    'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Title', 'unfinityplus'),
                    'param_name' => 'title',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' =>esc_html__('Position', 'unfinityplus'),
                    'param_name' => 'position',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'textarea',
                    'heading' =>esc_html__('Description', 'unfinityplus'),
                    'param_name' => 'desc',
                    'admin_label' => true,
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                ),
                array(
                    'type' => 'param_group',
                    'heading' => esc_html__( 'Social', 'unfinityplus' ),
                    'param_name' => 'social',
                    'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
                    'value' => '',
                    'group' => esc_html__('Source Settings', 'unfinityplus'),
                    'params' => array(
                        array(
                            'type' => 'iconpicker',
                            'heading' => esc_html__( 'Icon', 'unfinityplus' ),
                            'param_name' => 'icon',
                            'value' => '',
                            'settings' => array(
                                'emptyIcon' => true,
                                'type' => 'fontawesome',
                                'iconsPerPage' => 200,
                            ),
                            'description' => esc_html__( 'Select icon from library.', 'unfinityplus' ),
                            'admin_label' => true,
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' =>esc_html__('Link', 'unfinityplus'),
                            'param_name' => 'social_link',
                            'admin_label' => true,
                        ),
                    ),
                ),
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Title Color', 'unfinityplus'),
            'param_name' => 'title_color',
            'value' => '',
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_team_carousel--layout5.php',
                )
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Social Hover Style', 'unfinityplus'),
            'param_name' => 'social_hover_style',
            'value' => array(
                'Style 1' => 'hover-style1',
                'Style 2' => 'hover-style2',
            ),
            'group' => esc_html__('Source Settings', 'unfinityplus'),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_team_carousel--layout5.php',
                )
            ),
        ),

    ));

$args = unfinityplus_add_vc_extra_param($args);
vc_map($args);

class WPBakeryShortCode_cms_team_carousel extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>