<?php
vc_map(array(
    'name' => 'Text Box',
    'base' => 'cms_textbox',
    'class'    => 'ct-icon-element',
    'description' => esc_html__( 'Text Box Displayed', 'unfinityplus' ),
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(
        array(
            'type' => 'textarea',
            'heading' => esc_html__( 'Text', 'unfinityplus' ),
            'param_name' => 'text',
            'value' => '',
            'admin_label' => true,
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__('Text Color', 'unfinityplus'),
            'param_name' => 'text_color',
            'value' => '',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font Size', 'unfinityplus' ),
            'param_name' => 'text_font_size',
            'value' => '',
            'description' => 'Enter number.',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line Height', 'unfinityplus' ),
            'param_name' => 'text_line_height',
            'value' => '',
            'description' => 'Enter number.',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Text Decoration', 'unfinityplus'),
            'param_name' => 'text_align',
            'value' => array(
                'Text Left' => 'text-left',
                'Text Center' => 'text-center',
                'Text Right' => 'text-right',
            ),
            'std' => 'text-left',
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Style', 'unfinityplus'),
            'param_name' => 'text_style',
            'value' => array(
                'Normal' => 'style-normal',
                'Border' => 'style-border',
                'Icon' => 'style-icon',
            ),
            'std' => 'text-left',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_textbox extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>