<?php
vc_map(
    array(
        'name'     => esc_html__('Tickets', 'unfinityplus'),
        'base'     => 'cms_tickets',
        'class'    => 'ct-icon-element',
        'description' => esc_html__( 'Tickets Displayed', 'unfinityplus' ),
        'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
        'params'   => array(
            array(
                'type' => 'cms_template_img',
                'param_name' => 'cms_template',
                'shortcode' => 'cms_tickets',
                'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
                'admin_label' => true,
                'std' => 'cms_tickets.php',
                'group' => esc_html__('Template', 'unfinityplus'),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Content', 'unfinityplus' ),
                'param_name' => 'content_list',
                'description' => esc_html__( 'Enter values for team item', 'unfinityplus' ),
                'value' => '',
                'group' => esc_html__('Source Settings', 'unfinityplus'),
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'unfinityplus' ),
                        'param_name' => 'ct_image',
                        'value' => '',
                        'description' => esc_html__( 'Select image from media library.', 'unfinityplus' ),
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Price', 'unfinityplus'),
                        'param_name' => 'ct_price',
                        'admin_label' => true,
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Date', 'unfinityplus'),
                        'param_name' => 'ct_date',
                        'admin_label' => true,
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' =>esc_html__('Description', 'unfinityplus'),
                        'param_name' => 'ct_desc',
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' =>esc_html__('Book Button Text', 'unfinityplus'),
                        'param_name' => 'ct_btn_text',
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                    array(
                        'type' => 'vc_link',
                        'class' => '',
                        'heading' => esc_html__('Book Button Link', 'unfinityplus'),
                        'param_name' => 'ct_btn_link',
                        'value' => '',
                        'group' => esc_html__('Source Settings', 'unfinityplus'),
                    ),
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
                'group'            => esc_html__('Grid Settings', 'unfinityplus')
            ),
        )
    )
);

class WPBakeryShortCode_cms_tickets extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        $html_id = cmsHtmlID('cms-tickets-grid');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}

?>