<?php
vc_map(array(
    'name' => 'Video Player',
    'base' => 'cms_video_player',
    'class'    => 'ct-icon-element',
    'description' => 'Embed Youtube/Vimeo player',
    'category' => esc_html__('CaseThemes Shortcodes', 'unfinityplus'),
    'params' => array(

        /* Template */
        array(
            'type' => 'cms_template_img',
            'param_name' => 'cms_template',
            'shortcode' => 'cms_video_player',
            'heading' => esc_html__('Shortcode Template', 'unfinityplus'),
            'admin_label' => true,
            'group' => esc_html__('Template', 'unfinityplus'),
            'std' => 'cms_video_player.php'
        ),

        array(
            'type' => 'vc_link',
            'heading' => esc_html__( 'Video Url', 'unfinityplus' ),
            'param_name' => 'video_link',
            'value' => 'https://www.youtube.com/watch?v=SF4aHwxHtZ0',
            'description' => 'Video url on Youtube, Vimeo'
        ),

        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Video Intro Image', 'unfinityplus' ),
            'param_name' => 'video_bg_image',
            'value' => '',
        ),

        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Video Intro Image Two', 'unfinityplus' ),
            'param_name' => 'video_bg_image2',
            'value' => '',
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_video_player--layout2.php',
                )
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Video Button Style', 'unfinityplus'),
            'param_name' => 'btn_style',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
                'Style 3' => 'style3',
                'Style 4' => 'style4',
                'Style 5' => 'style5',
                'Style 6' => 'style6',
            ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_video_player.php',
                )
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Video Intro Style', 'unfinityplus'),
            'param_name' => 'intro_style',
            'value' => array(
                'Style 1' => 'style1',
                'Style 2' => 'style2',
                'Style 3' => 'style3',
                'Style 4' => 'style4',
            ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_video_player.php',
                )
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Video Button Absolute', 'unfinityplus'),
            'param_name' => 'btn_absolute',
            'value' => array(
                'No' => 'no',
                'Yes' => 'yes',
            ),
            'dependency' => array(
                'element'=>'cms_template',
                'value'=>array(
                    'cms_video_player.php',
                )
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'unfinityplus' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in Custom CSS.', 'unfinityplus' ),
            'group'            => esc_html__('Extra', 'unfinityplus')
        ),
        array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'Animation Style', 'unfinityplus' ),
            'param_name' => 'animation',
            'description' => esc_html__( 'Choose your animation style', 'unfinityplus' ),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Extra', 'unfinityplus'),
        ),
    )
));

class WPBakeryShortCode_cms_video_player extends CmsShortCode
{

    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}

?>