<?php
extract(shortcode_atts(array(

    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'el_class'             => '',
    'img_size'             => '600x474',

), $atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-blog-carousel');
extract(cms_get_posts_of_grid('post', $atts));
extract(unfinityplus_get_param_carousel($atts));
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout2 owl-carousel <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
    <?php if (is_array($posts)):
        foreach ($posts as $post) {
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner ct-fade-in">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : ?>
                        <div class="item-featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post( $thumbnail ); ?>
                            </a>
                            <div class="item-date">
                                <h6><?php echo get_the_date('d', $post->ID); ?></h6>
                                <span><?php echo get_the_date('M', $post->ID); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="item-holder">
                        <h3 class="item-title">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                        </h3>
                        <div class="item-gap"></div>
                        <ul class="entry-meta">
                            <li><?php the_author_posts_link(); ?></li>
                            <li class="item-category"><?php the_terms( $post->ID, 'category', ' ', ', ' ); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
</div>