<?php
extract(shortcode_atts(array(
    'id'        => '',
    'animation' => '',
    'el_class'  => '',
    'el_title'  => '',
    'el_sub_title'  => '',
    'el_description'  => '',
    'el_address'  => '',
    'el_phone'  => '',
    'el_email'  => '',
    'map_image'  => '',
    'el_map_iframe'  => '',
    'form2_style'  => 'form-style1',
), $atts));
$map_image_url = '';
if (!empty($map_image)) {
    $attachment_image = wp_get_attachment_image_src($map_image, 'full');
    $map_image_url = $attachment_image[0];
}
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
if(class_exists('WPCF7')) { ?>
<div class="ct-contact-form-wrap">
    <div class="ct-contact-form-layout1 <?php echo esc_attr( $el_class.' '.$animation_classes.' '.$form2_style )?>">
    	<?php if (!empty($map_image)) { ?>
    		<div class="map-image bg-image" style="background-image: url(<?php echo esc_url($map_image_url); ?>);"></div>
    	<?php } ?>
    	<div class="container">
	        <div class="ct-contact-form-inner">
	        	<?php if($form2_style == 'form-style1') : ?>
		        	<div class="ct-contact-form-head">
		        		<div class="ct-contact-form-meta">
		        			<h3><?php echo esc_attr($el_title); ?></h3>
		        			<h6><?php echo esc_attr($el_sub_title); ?></h6>
		        		</div>
		        		<div class="ct-contact-form-desc"><?php echo wp_kses_post($el_description); ?></div>
		        	</div>
		        <?php endif; ?>
	        	<div class="ct-contact-form-body">
	        		<div class="row">
	        			<div class="col-md-12 col-md-4 col-lg-4">
	        				<ul class="ct-contact-form-holder">
	        					<?php if(!empty($el_address)) :?>
	        						<li><i class="fa fa-home"></i><?php echo esc_attr($el_address); ?></li>
	        					<?php endif; ?>
	        					<?php if(!empty($el_phone)) :?>
	        						<li><a href="tel:<?php echo esc_attr($el_phone); ?>"><i class="fa fa-phone"></i><?php echo esc_attr($el_phone); ?></a></li>
	        					<?php endif; ?>
	        					<?php if(!empty($el_email)) :?>
	        						<li><a href="mailto:<?php echo esc_attr($el_email); ?>"><i class="fa fa-envelope"></i><?php echo esc_attr($el_email); ?></a></li>
	        					<?php endif; ?>
	        				</ul>
	        				<?php if(!empty($el_address)) :?>
	        					<span class="map-popup"><i class="fa fa-map-pin"></i><?php echo esc_html__( 'Find us in map', 'unfinityplus' ) ?></span>
	        				<?php endif; ?>
	        			</div>
	        			<div class="col-md-12 col-md-8 col-lg-8"><?php echo do_shortcode('[contact-form-7 id="'.esc_attr( $id ).'"]'); ?></div>
	        		</div>
	        	</div>
	        </div>
	    </div>
    </div>
    <?php if(!empty($el_map_iframe)) : ?>
	    <div class="ct-modal ct-contact-map-popup">
	    	<div class="ct-close"></div>
	    	<div class="ct-modal-content">
	    		<?php echo do_shortcode( '[vc_gmaps link="'.$el_map_iframe.'"]' ) ?>
	    	</div>
	    </div>
	<?php endif; ?>
</div>
<?php } ?>