<?php
extract(shortcode_atts(array(
    'id'        => '',
    'el2_title'        => '',
    'contact_image'        => '',
    'animation' => '',
    'el_class'  => '',
), $atts));
$contact_image_url = '';
if (!empty($contact_image)) {
    $attachment_image = wp_get_attachment_image_src($contact_image, 'full');
    $contact_image_url = $attachment_image[0];
}
$contact_class = '';
if(!empty($contact_image_url)) {
    $contact_class = 'col-xl-6 col-lg-6 col-md-6';
} else {
    $contact_class = 'col-12';
}
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );
if(class_exists('WPCF7')) { ?>
    <div class="ct-contact-form-layout3 <?php echo esc_attr( $el_class.' '.$animation_classes )?>">
        <div class="ct-contact-form-inner row">
            <div class="ct-contact-form <?php echo esc_attr( $contact_class ); ?>">
                <div class="ct-contact-form-holder <?php if(empty($contact_image_url)) { echo 'no-intro'; } ?>">
                    <h3 class="el-title"><?php echo esc_attr($el2_title); ?></h3>
                    <?php echo do_shortcode('[contact-form-7 id="'.esc_attr( $id ).'"]'); ?>
                </div>
            </div>
            <?php if(!empty($contact_image_url)) : ?>
                <div class="ct-contact-image col-xl-6 col-lg-6 col-md-6">
                    <div class="ct-contact-image-inner bg-image" style="background-image: url(<?php echo esc_url($contact_image_url); ?>); "></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php } ?>