<?php
extract(shortcode_atts(array(

    'content_list' => '',
    'el_class' => '',
    'animation' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-fancybox-carousel');
extract(unfinityplus_get_param_carousel($atts));
$el_content_list = array();
$el_content_list = (array) vc_param_group_parse_atts( $content_list );
$animation_tmp = isset($animation) ? $animation : '';
$animation_classes = $this->getCSSAnimation( $animation_tmp );

if(!empty($el_content_list)) : ?>
    <div id="<?php echo esc_attr($html_id);?>" class="ct-fancybox-carousel layout3 owl-carousel <?php echo esc_attr( $el_class.' '.$animation_classes ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($el_content_list as $key => $value) {
            $title = isset($value['fancybox_title']) ? $value['fancybox_title'] : '';
            $content = isset($value['fancybox_content']) ? $value['fancybox_content'] : '';
            $sub_title = isset($value['fancybox_sub_title']) ? $value['fancybox_sub_title'] : '';
            $button_text = isset($value['button_text']) ? $value['button_text'] : '';
            $button_link = isset($value['button_link']) ? $value['button_link'] : '';
            $link = vc_build_link($button_link);
            $a_href = '';
            $a_target = '';
            if ( strlen( $link['url'] ) > 0 ) {
                $a_href = $link['url'];
                $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
            }
            $image = isset($value['fancybox_image']) ? $value['fancybox_image'] : '';
            $img_size = isset($value['img_size']) ? $value['img_size'] : '384x449';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="ct-fancybox-item">
                <div class="ct-fancybox-item-inner">
                    <?php if(!empty($image)) { ?>
                        <div class="ct-fancybox-featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php } ?>
                    <div class="ct-fancybox-holder">
                        <?php if(!empty($sub_title)) : ?>
                            <div class="ct-fancybox-subtitle">
                                <?php echo esc_attr($sub_title); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="ct-fancybox-title">
                            <?php echo esc_attr($title); ?>
                        </h3>
                        <div class="ct-fancybox-content">
                            <?php echo wp_kses_post( $content  ); ?>
                        </div>
                        <?php if(!empty($button_text)): ?>
                            <div class="ct-fancybox-button">
                                <a class="btn btn-outline" href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>">
                                    <?php echo esc_attr( $button_text ); ?>
                                    <i class="zmdi zmdi-arrow-right"></i>        
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php endif;?>