<?php
extract(shortcode_atts(array(

    'images' => '',
    'img_size' => 'large',
    'bullets' => '',
    'el_class' => '',

), $atts));
$ct_images = explode( ',', $images );
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-image-gallery-carousel');
extract(unfinityplus_get_param_carousel($atts)); ?>

<div class="ct-carousel-wrap">
    <div id="<?php echo esc_attr($html_id);?>" class="ct-carousel ct-image-gallery-carousel default owl-carousel images-light-box <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?> data-dotscontainer="true">
        <?php foreach ($ct_images as $img_id) :
            $img = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="cms-image-item">
                <a class="light-box" href="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'full'));?>">
                    <?php echo wp_kses_post($thumbnail); ?>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
    <?php if($bullets == 'true') : ?>
        <div class="slider-nav clearfix">
            <div class="thumbs">
                <?php foreach ($ct_images as $img_id): 
                    $img_thumb = wpb_getImageBySize( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => '300x195',
                        'class'      => '',
                    ));
                    $t_thumbnail = $img_thumb['thumbnail'];
                    ?>
                    <div class="thumb">
                        <?php echo wp_kses_post($t_thumbnail); ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>