<?php
$primary_color_gradient = unfinityplus_get_opt( 'primary_color_gradient' );
$primary_gradient1 = $primary_color_gradient['from'];
$primary_gradient2 = $primary_color_gradient['to'];
extract(shortcode_atts(array(                                  
    'color' => 'regular',                                                                                                                                                                                             
    'regular_color' => '',                                                                                                                                                                                             
    'gradient_color1' => $primary_gradient1,                                                                                                                                                                                             
    'gradient_color2' => $primary_gradient2,                                                                                                                                                                                             
    'position' => 'in-row',                                                                                                                                                                                          
    'flip' => 'horizontal',                                                                                                                                                                                            
    'text' => '',                                                                                                                                                                                            
    'text_top' => '',                                                                                                                                                                                            
    'text_left' => '',                                                                                                                                                                                            
    'text_color' => '',                                                                                                                                                                                            
    'text_font_size' => '',                                                                                                                                                                                            
), $atts));
$html_id = cmsHtmlID('ct-row-overlay');
?>

<div id="<?php echo esc_attr($html_id) ?>" 
	class="ct-row-overlay <?php echo esc_attr( $position ); ?> <?php if($color == 'gradient') { echo 'color-gradient'; } ?>"  
	<?php if($color == 'regular') : ?> style="background-color: <?php echo esc_attr( $regular_color ); ?>" <?php endif; ?>>
	<?php if($color == 'gradient' && $flip == 'horizontal') { ?>
		<style type="text/css">
			#<?php echo esc_attr( $html_id ); ?>.color-gradient {
				background-image: -webkit-gradient(linear, left bottom, left top, from(<?php echo esc_attr($gradient_color1); ?>), to(<?php echo esc_attr($gradient_color2); ?>));
				background-image: -webkit-linear-gradient(center bottom, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:    -moz-linear-gradient(center bottom, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:     -ms-linear-gradient(center bottom, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:      -o-linear-gradient(center bottom, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:         linear-gradient(center bottom, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='<?php echo esc_attr($gradient_color1); ?>', endColorstr='<?php echo esc_attr($gradient_color2); ?>', GradientType=1 );
			}
		</style>
	<?php } ?>
	<?php if($color == 'gradient' && $flip == 'vertical') { ?>
		<style type="text/css">
			#<?php echo esc_attr( $html_id ); ?>.color-gradient {
				background-image: -webkit-gradient(linear, left top, right top, from(<?php echo esc_attr($gradient_color1); ?>), to(<?php echo esc_attr($gradient_color2); ?>));
				background-image: -webkit-linear-gradient(center left, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:    -moz-linear-gradient(center left, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:     -ms-linear-gradient(center left, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:      -o-linear-gradient(center left, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				background-image:         linear-gradient(center left, <?php echo esc_attr($gradient_color1); ?>, <?php echo esc_attr($gradient_color2); ?>);
				filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='<?php echo esc_attr($gradient_color1); ?>', endColorstr='<?php echo esc_attr($gradient_color2); ?>', GradientType=1 );
			}
		</style>
	<?php } ?>
	<span style="color:<?php echo esc_attr($text_color); ?>; font-size:<?php echo esc_attr($text_font_size).'px'; ?>; top:<?php echo esc_attr($text_top); ?>; left:<?php echo esc_attr($text_left); ?>;"><?php echo esc_attr($text); ?></span>
</div>