<?php
extract(shortcode_atts(array(

    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'el_class'             => '',
    'img_size'             => '650x506',

), $atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-portfolio-carousel');
extract(cms_get_posts_of_grid('portfolio', $atts));
extract(unfinityplus_get_param_carousel($atts));
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-portfolio-carousel owl-carousel <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
    <?php if (is_array($posts)):
        foreach ($posts as $post) {
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ) );
            $thumbnail    = $img['thumbnail'];
            $media_class = '';
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) {
                $media_class = 'has-thumnail';
            } else {
                $media_class = 'no-thumnail';
            }
            ?>
            <div class="ct-carousel-item">
                <div class="item-featured">
                     <a class="<?php echo esc_attr( $media_class ); ?>" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                        <?php echo wp_kses_post($thumbnail); ?>
                     </a>
                </div>
                <div class="item-holder" style="<?php if(!empty($hover_overlay_color)) { echo 'background-color:'.esc_attr($hover_overlay_color).';'; } ?>">
                    <div class="item-holder-inner">
                        <div class="item-meta image-light-box">
                            <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : 
                                $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false);
                                ?>
                                <a class="item-zoom light-box" href="<?php echo esc_url($thumbnail_url[0]); ?>"><i class="fa fa-search"></i></a>
                            <?php endif; ?>
                            <a class="item-more" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><i class="fa fa-link"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
</div>