<?php
$atts_extra = shortcode_atts(array(
    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'gap'                  => '30',
    'post_ids'             => '',
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'el_class'             => '',
    'img_size'             => '600x400',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$tax = array();
extract(cms_get_posts_of_grid('post', $atts));
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-recent-news <?php echo esc_attr($el_class); ?>">

    <div class="ct-recent-news-inner row">
        <?php if (is_array($posts)): ?>
            <div class="ct-recent-news-left col-lg-6 col-md-6 col-sm-12">
                <?php foreach ($posts as $key => $post) {
                    the_post();
                    $img_id = get_post_thumbnail_id($post->ID);
                    $img = wpb_getImageBySize( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class'      => '',
                    ));
                    $thumbnail = $img['thumbnail'];
                    if($key == 0) { ?>
                        <div class="ct-recent-news-item">
                            <div class="item-featured">
                                 <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                 </a>
                            </div>
                            <div class="item-body">
                                <ul class="item-meta">
                                    <li><i class="fa fa-user"></i><?php the_author_posts_link(); ?></li>
                                    <li><i class="fa fa-clock-o"></i><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></li>
                                </ul>
                                <h3 class="item-title">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                                </h3>
                                <div class="item-content">
                                    <?php echo wp_trim_words( $post->post_excerpt, $num_words = 16, $more = null ); ?>
                                </div>
                            </div>
                        </div>
                    <?php }
                } ?>
            </div>
        <?php endif; ?>
        <?php if (is_array($posts)): ?>
            <div class="ct-recent-news-right col-lg-6 col-md-6 col-sm-12">
                <?php foreach ($posts as $key2 => $post2) {
                    if($key2 != 0) { ?>
                        <div class="ct-recent-news-item">
                            <div class="item-body">
                                <ul class="item-meta">
                                    <li><i class="fa fa-user"></i><?php the_author_posts_link(); ?></li>
                                    <li><i class="fa fa-clock-o"></i><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post2->ID); ?></li>
                                </ul>
                                <h3 class="item-title">
                                    <a href="<?php echo esc_url(get_permalink( $post2->ID )); ?>"><?php echo esc_attr(get_the_title($post2->ID)); ?></a>
                                </h3>
                            </div>
                        </div>
                    <?php }
                } ?>
            </div>
        <?php endif; ?>
    </div>
</div>