<?php
$atts_extra = shortcode_atts(array(
    'content_list'                  => '',
    'col_lg'               => 4,
    'col_md'               => 3,
    'col_sm'               => 2,
    'col_xs'               => 1,
    'el_class'             => '',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);

$col_lg = 12 / $col_lg;
$col_md = 12 / $col_md;
$col_sm = 12 / $col_sm;
$col_xs = 12 / $col_xs;
$grid_sizer = "col-xl-{$col_lg} col-lg-{$col_md} col-md-{$col_sm} col-sm-{$col_xs} col-{$col_xs}";
wp_enqueue_script('isotope');
wp_enqueue_script('imagesloaded');
wp_enqueue_script('unfinityplus-isotope', get_template_directory_uri() . '/assets/js/isotope.ct.js', array('jquery'), '1.0.0', true);
$team_content_list = (array) vc_param_group_parse_atts( $content_list );
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-grid-room <?php echo esc_attr($el_class); ?>">

    <div class="ct-grid-inner ct-grid-masonry row" data-gutter="15">
        <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        <?php foreach ($team_content_list as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $price = isset($value['price']) ? $value['price'] : '';
            $desc = isset($value['desc']) ? $value['desc'] : '';
            $button_text = isset($value['button_text']) ? $value['button_text'] : '';
            $button_link = isset($value['button_link']) ? $value['button_link'] : '';
            $link = vc_build_link($button_link);
            $a_href = '';
            $a_target = '';
            if ( strlen( $link['url'] ) > 0 ) {
                $a_href = $link['url'];
                $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
            }
            $room_info = isset($value['room_info']) ? $value['room_info'] : '';
            $room_info_list = (array) vc_param_group_parse_atts( $room_info );
            $image = isset($value['image']) ? $value['image'] : '';
            $img_size = isset($value['img_size']) ? $value['img_size'] : 'full';
            $img = wpb_getImageBySize( array(
                'attach_id'  => $image,
                'thumb_size' => $img_size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            $item_class = "grid-item col-xl-{$col_lg} col-lg-{$col_md} col-md-{$col_sm} col-sm-{$col_xs} col-{$col_xs}";
            ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <div class="grid-item-inner">
                    <?php if(!empty($image)) : ?>
                        <div class="room-featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <?php if(!empty($button_text)): ?>
                                <div class="room-button">
                                    <a class="btn btn-outline" href="<?php echo esc_url($a_href);?>" target="<?php  echo esc_attr($a_target); ?>"><?php echo esc_attr( $button_text ); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="room-holder">
                        <div class="room-meta">
                            <h3 class="room-title">
                                <?php echo esc_attr($title); ?>
                            </h3>
                            <div class="room-price"><?php echo wp_kses_post( $price ); ?></div>
                        </div>
                        <div class="room-desc">
                            <?php echo esc_attr($desc); ?>
                        </div>
                        <?php if(!empty($room_info_list)): ?>
                            <div class="room-info">
                                <ul class="room-info-inner">
                                    <?php foreach ($room_info_list as $key => $value) {
                                        $info_text = isset($value['info_text']) ? $value['info_text'] : '';
                                        $icon_class = isset($value['info_icon']) ? $value['info_icon'] : ''; ?>
                                        <li><i class="<?php echo esc_attr( $icon_class ); ?>"></i><span><?php echo esc_attr($info_text); ?></span></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

</div>