<?php
$atts_extra = shortcode_atts(array(
    'content_list'                  => '',
    'el_class'             => '',
), $atts);
$atts = array_merge($atts_extra, $atts);
extract($atts);
$schedule_content_list = (array) vc_param_group_parse_atts( $content_list );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-grid ct-schedule-grid default <?php echo esc_attr($el_class); ?>">
    
    <?php foreach ($schedule_content_list as $key => $value) {
        $ct_title = isset($value['ct_title']) ? $value['ct_title'] : '';
        $ct_content = isset($value['ct_content']) ? $value['ct_content'] : '';
        $ct_time_label = isset($value['ct_time_label']) ? $value['ct_time_label'] : '';
        $ct_time = isset($value['ct_time']) ? $value['ct_time'] : '';
        $ct_room = isset($value['ct_room']) ? $value['ct_room'] : '';
        $ct_speakers_label = isset($value['ct_speakers_label']) ? $value['ct_speakers_label'] : '';
        $ct_speakers = isset($value['ct_speakers']) ? $value['ct_speakers'] : '';
        $ct_image = isset($value['ct_image']) ? $value['ct_image'] : '';
        $image_url = '';
        if (!empty($ct_image)) {
            $attachment_image = wp_get_attachment_image_src($ct_image, 'medium');
            $image_url = $attachment_image[0];
        }
        ?>
        <div class="ct-schedule-item row">
            <div class="ct-schedule-holder col-xl-8 col-lg-8 col-md-12">
                <div class="ct-schedule-holder-inner">
                    <?php if(!empty($image_url)) : ?>
                        <div class="ct-schedule-media bg-image" style="background-image: url(<?php echo esc_url( $image_url ); ?>);"></div>
                    <?php endif; ?>
                    <div class="ct-schedule-content">
                        <h3><?php echo esc_attr( $ct_title ); ?></h3>
                        <p><?php echo wp_kses_post($ct_content ); ?></p>
                    </div>
                </div>
            </div>
            <div class="ct-schedule-meta col-xl-4 col-lg-4 col-md-12">
                <div class="ct-schedule-meta-inner">
                    <ul>
                        <?php if(!empty($ct_time)) : ?>
                            <li>
                                <i class="fa fa-clock-o"></i>
                                <?php if(!empty($ct_time_label)) { ?>
                                    <label><?php echo esc_attr( $ct_time_label ); ?></label>
                                <?php } else { ?>
                                    <label><?php echo esc_html__( 'Time:', 'unfinityplus' ); ?></label>
                                <?php } ?>
                                <?php echo esc_attr($ct_time); ?>
                            </li>
                        <?php endif; ?>
                        <?php if(!empty($ct_room)) : ?>
                            <li>
                                <i class="fa fa-map-marker"></i>
                                <?php echo esc_attr($ct_room); ?>
                            </li>
                        <?php endif; ?>
                        <?php if(!empty($ct_speakers)) : ?>
                            <li class="ct-schedule-speake">
                                <i class="fa fa-bullhorn"></i>
                                <?php if(!empty($ct_speakers_label)) { ?>
                                    <label><?php echo esc_attr( $ct_speakers_label ); ?></label>
                                <?php } else { ?>
                                    <label><?php echo esc_html__( 'Speakers:', 'unfinityplus' ); ?></label>
                                <?php } ?>
                                <span><?php echo esc_attr($ct_speakers); ?></span>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php } ?>
</div>