<?php
extract(shortcode_atts(array(

    'source'               => '',
    'orderby'              => 'date',
    'order'                => 'DESC',
    'limit'                => '6',
    'post_ids'             => '',
    'el_class'             => '',
    'img_size'             => '680x365',
    'icon_item'             => '',

), $atts));
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-service-carousel');
extract(cms_get_posts_of_grid('service', $atts));
extract(unfinityplus_get_param_carousel($atts));
$icon_items = (array) vc_param_group_parse_atts($icon_item);
wp_enqueue_script( 'waypoints' );
wp_enqueue_script( 'vc_waypoints' );
wp_enqueue_style( 'vc_animate-css' );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-carousel ct-service-carousel-layout2 owl-carousel <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
    <?php if (is_array($posts)):
        foreach ($posts as $key => $post) {
            $icon_image = isset($icon_items[$key]['icon']) ? $icon_items[$key]['icon'] : '';
            if(!empty($icon_image)) {
                $attachment_icon = wp_get_attachment_image_src($icon_image, 'full');
                $icon_image_url = $attachment_icon[0];
            }
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class'      => '',
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="ct-carousel-item">
                <div class="grid-item-inner">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) : ?>
                        <div class="item-featured">
                             <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post( $thumbnail ); ?>
                             </a>
                        </div>
                    <?php endif; ?>
                    <div class="item-holder">
                        <div class="item-holder-inner">
                            <?php if(!empty($icon_image)) { ?>
                                <div class="item-icon"><img src="<?php echo esc_url($icon_image_url); ?>" /></div>
                            <?php } ?>
                            <div class="item-meta">
                                <h3 class="item-title">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                                </h3>
                                <div class="item-gap"></div>
                                <div class="item-mmore">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html__( 'Learn More', 'unfinityplus' ) ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php }
    endif; ?>
</div>