<?php
extract(shortcode_atts(array(

    'testimonial_item_l6' => '',
    'style_l6' => 'style1',
    'el_class' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-testimonial-carousel');
extract(unfinityplus_get_param_carousel($atts));
$testimonials = (array) vc_param_group_parse_atts($testimonial_item_l6);
if(!empty($testimonials)) : ?>

    <div id="<?php echo esc_attr($html_id);?>" class="ct-testimonial-carousel layout6 owl-carousel <?php echo esc_attr( $style_l6.' '.$el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($testimonials as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $video_text = isset($value['video_text']) ? $value['video_text'] : '';
            $video_link = isset($value['video_link']) ? $value['video_link'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $image_url = '';
            if (!empty($image)) {
                $attachment_image = wp_get_attachment_image_src($image, 'thumbnail');
                $image_url = $attachment_image[0];
            }
            ?>
            <div class="ct-testimonial-item">
                <?php if(!empty($image_url)): ?>
                    <div class="ct-testimonial-image"><img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $title ); ?>" /></div>
                <?php endif; ?>
                <div class="ct-testimonial-holder">
                    <div class="ct-testimonial-content"><?php echo apply_filters('the_content', $content); ?></div>
                    <div class="ct-testimonial-meta">
                        <h3 class="ct-testimonial-title"><?php echo esc_html($title); ?></h3>
                        <?php if(!empty($video_text)) : ?>
                            <div class="ct-testimonial-button"><a class="btn-video" href="<?php echo esc_url($video_link); ?>"><i class="fa fa-play-circle-o"></i><?php echo esc_attr($video_text); ?></a></div>
                        <?php endif; ?>
                    </div>
                </div>   
            </div>
        <?php } ?>
    </div>

<?php endif;?>