<?php
extract(shortcode_atts(array(

    'testimonial_item' => '',
    'title_color' => '',
    'position_color' => '',
    'content_color' => '',
    'el_class' => '',

), $atts));

wp_enqueue_script( 'owl-carousel' );
wp_enqueue_script( 'unfinityplus-carousel' );
$html_id = cmsHtmlID('ct-testimonial-carousel');
extract(unfinityplus_get_param_carousel($atts));
$testimonials = (array) vc_param_group_parse_atts($testimonial_item);
if(!empty($testimonials)) : ?>

    <div id="<?php echo esc_attr($html_id);?>" class="ct-testimonial-carousel default owl-carousel owl-nav-middle <?php echo esc_attr( $el_class ); ?>" <?php echo !empty($carousel_data) ?  esc_attr($carousel_data) : '' ?>>
        <?php foreach ($testimonials as $key => $value) {
            $title = isset($value['title']) ? $value['title'] : '';
            $content = isset($value['content']) ? $value['content'] : '';
            $position = isset($value['position']) ? $value['position'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $image_url = '';
            if (!empty($image)) {
                $attachment_image = wp_get_attachment_image_src($image, 'thumbnail');
                $image_url = $attachment_image[0];
            }
            ?>
            <div class="ct-testimonial-item">
                <div class="ct-testimonial-quote">
                    <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         width="508.044px" height="508.044px" viewBox="0 0 508.044 508.044" style="enable-background:new 0 0 508.044 508.044;"
                         xml:space="preserve">
                        <g>
                            <g>
                                <path d="M0.108,352.536c0,66.794,54.144,120.938,120.937,120.938c66.794,0,120.938-54.144,120.938-120.938
                                    s-54.144-120.937-120.938-120.937c-13.727,0-26.867,2.393-39.168,6.61C109.093,82.118,230.814-18.543,117.979,64.303
                                    C-7.138,156.17-0.026,348.84,0.114,352.371C0.114,352.426,0.108,352.475,0.108,352.536z"/>
                                <path d="M266.169,352.536c0,66.794,54.144,120.938,120.938,120.938s120.938-54.144,120.938-120.938S453.9,231.599,387.106,231.599
                                    c-13.728,0-26.867,2.393-39.168,6.61C375.154,82.118,496.875-18.543,384.04,64.303C258.923,156.17,266.034,348.84,266.175,352.371
                                    C266.175,352.426,266.169,352.475,266.169,352.536z"/>
                            </g>
                        </g>
                    </svg>
                </div>
                <div class="ct-testimonial-content" style="<?php if(!empty($content_color)) { echo 'color:'.esc_attr($content_color).';'; } ?>"><?php echo esc_html($content); ?></div>
                <div class="ct-testimonial-holder">
                    <?php if(!empty($image_url)): ?>
                        <div class="ct-testimonial-image"><img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $title ); ?>" /></div>
                    <?php endif; ?>
                    <div class="ct-testimonial-meta">
                        <h3 class="ct-testimonial-title" style="<?php if(!empty($title_color)) { echo 'color:'.esc_attr($title_color).';'; } ?>"><?php echo esc_html($title); ?></h3>
                        <span class="ct-testimonial-position" style="<?php if(!empty($position_color)) { echo 'color:'.esc_attr($position_color).';'; } ?>"><?php echo esc_html($position); ?></span>
                    </div>
                </div>   
            </div>
        <?php } ?>
    </div>

<?php endif;?>